<?php

namespace App\Service;
use DB;
use App\Models\User;
use App\Models\StockTransaction;
use App\Models\Item;
use App\Service\StaticMaster;
use App\Service\DailyService;
use Log;

class ManufacturingStockService
{

    // Savings Stock Entries for Transactions 
    //Sale , Purchase , Credit Note , Debit Note
    public function saveStockEntries( $transaction,$entity,$inout){  
        // Declaration of model
        $model = app("App\Models\\".$entity."Item");

        // Getting all the Items
        $subtrans = $model::where('transaction_id',$transaction['id'])->where('rolledback',0)->get();

        foreach($subtrans as $row){
            $present = StockTransaction::where('transaction_type',StaticMaster::$SALE_TRANSACTION_TYPE)
                ->where('transaction_id',$transaction['id'])
                ->where('rolledback',0)
                ->first();

            if($present==null){
                // Log::info("Inout :".$entity);
                Log::info("Inout :".$inout);
                $obj = array();
                $obj['item_id']=$row['item_id'];
                $obj['warehouse_id']=$transaction['warehouse_id']==null?0:$transaction['warehouse_id'];
                $obj['transaction_date']=$transaction['transaction_date'];
                $obj['unit_id']=$row['unit_id']??0;
                $obj['transaction_id']=$transaction['id'];
                $obj['inout']=$inout;     //inout=2 for out and //inout=1 in
                $obj['updatestatus']=0;
                $obj['quantity']=$row['quantity'];
                $obj['transaction_type']=StaticMaster::$SALE_TRANSACTION_TYPE;
                $obj['fy']=$transaction['fy'];

                $stock_transaction = StockTransaction::create($obj);
                
                $itemupdate=$this->addItemStock($stock_transaction,$row['item_id'],$inout,$row['quantity']);
            }
        }
        return true;
    }

    //Adding Opening Stock
    public function addOpeningStock($request,$item){

        $present = StockTransaction::where('transaction_type',StaticMaster::$OPENING_STOCK_TYPE)
            ->where('item_id',$item['id'])
            ->where('fy',$request['fy'])
            ->where('rolledback',0)
            ->first();

        if($present==null){
            // Log::info("Inout :".$entity);
            // Log::info("Inout :".$inout);
            $obj = array();
            $obj['item_id']=$item['id']??0;
            $obj['warehouse_id']=$request['warehouse_id']??0;
            $obj['zone_id']=$request['zone_id']??0;
            $obj['rack_id']=$request['rack_id']??0;
            $obj['bin_id']=$request['bin_id']??0;
            $obj['transaction_date']=$request['as_on_date'];
            $obj['unit_id']=$item['unit_id']??0;
            $obj['transaction_id']=0;
            $obj['inout']=1;     //inout=2 for out and //inout=1 in
            $obj['updatestatus']=0;
            $obj['quantity']=$request['opening_stock'];
            $obj['transaction_type']=StaticMaster::$OPENING_STOCK_TYPE;
            $obj['fy']=$request['fy'];
        

            $stock_transaction = StockTransaction::create($obj);
            
            // $dailyService = new DailyService; 
            // $dailyService->updateNextDayStockStatus($stock_transaction);
            $itemupdate=$this->addItemStock($stock_transaction,$stock_transaction['item_id'],1,$request['opening_stock']);
        } else {

            //Rolled back existing Opening stock
            $itemupdate=$this->addItemStock($present,$present['item_id'],2,$present['quantity']);

            $present['quantity']=$request['opening_stock'];
            $present['transaction_date']=$request['as_on_date'];
            $present->update();

            //Updating New Opening Stock
            $itemupdate=$this->addItemStock($present,$present['item_id'],1,$present['quantity']);
        }
    }

    // Updating Stock Quantity in Item Table
    public function addItemStock($stock,$item_id,$inout,$quantity){
        // Updating Stock Quantity
        try {
            $item = Item::where('id',$item_id)->lockForUpdate()->first();

            if($inout==1){
                $item['stock']= $item['stock'] + intval($quantity);
            }else{
                $item['stock']= $item['stock'] - intval($quantity);
            }
            
            $item->update();

            // Updated Stock transation Status, Item Recorded Successfully 
            $stock['is_updated']=1;
            $stock->update();

        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

            // Return error message in JSON if ID not found
            return response()->json(['message' => 'Item Id is not valid'], 404);

        }
        return true;
    }

    // Adding GRN Receipt Stock 
    public function addGrnReceiptStock($item,$request){

        // Updating Stock Quantitytransaction
        $obj = array();
        $obj['item_id']=$item['item_id'];
        $obj['warehouse_id']=$request['warehouse_id']==null?0:$request['warehouse_id'];
        $obj['zone_id']=$request['zone_id']==null?0:$request['zone_id'];
        $obj['rack_id']=$request['rack_id']==null?0:$request['rack_id'];
        $obj['bin_id']=$request['bin_id']==null?0:$request['bin_id'];
        $obj['transaction_date']=$request['transaction_date'];
        $obj['unit_id']=$item['unit_id']??0;
        $obj['transaction_id']=$item['transaction_id'];
        $obj['inout']=1;     //inout=2 for out and //inout=1 in
        $obj['updatestatus']=0;
        $obj['quantity']=$item['gr_qty'];
        $obj['transaction_type']=StaticMaster::$GRN_PURCHASE_TYPE;
        $obj['fy']=$request['fy'];

        $stock_transaction = StockTransaction::create($obj);
        
        $itemupdate=$this->addItemStock($stock_transaction,$item['item_id'],$stock_transaction['inout'],$item['gr_qty']);
        
        return true;

    }

    // Adding Mannual Change in Stock Transaction
    public function mannualStockMove($request,$transaction,$tran_type,$inout){

        $obj = array();
        $obj['unit_id']=$request['unit_id']??0;
        $obj['item_id']=$request['item_id']??0;
        $obj['transaction_date']=$transaction['transaction_date'];
        $obj['transaction_id']=$transaction['id'];
        $obj['warehouse_id']=$request['warehouse_id']??0;
        $obj['zone_id']=$request['zone_id']??0;
        $obj['rack_id']=$request['rack_id']??0;
        $obj['bin_id']=$request['bin_id']??0;
        $obj['goods_condition_type']=$request['goods_condition_type']??1;
        $obj['inout']=$inout;     //inout=2 for out and //inout=1 in
        $obj['updatestatus']=0;
        $obj['quantity']=$request['quantity'];
        $obj['transaction_type']=$tran_type;
        $obj['fy']=$request['fy']??2024;
    
        $stock_transaction = StockTransaction::create($obj);
        
        $itemupdate=$this->addItemStock($stock_transaction,$stock_transaction['item_id'],$inout,$request['quantity']);

        return true;
    }

    public function rolledbackStock($transaction,$tran_type,$inout){

        try{

            $stock_transaction = StockTransaction::where('transaction_id',$transaction['id'])
                ->where('transaction_type',$tran_type)->lockForUpdate()->first();

            if($stock_transaction!=null){
                $itemupdate=$this->addItemStock($stock_transaction,$stock_transaction['item_id'],$inout,$stock_transaction['quantity']);

                $stock_transaction['rolledback']=1;
                $stock_transaction->update();

                return true;

            }else{

                return false;
            }

        }catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

            // Return false
            return false;

        }
    }
}