<?php

namespace App\Service;
use DB;
use App\Models\User;
use App\Models\Organisation;
use App\Models\UserOrganisation;
use App\Models\OrganisationRolePermission;
use Illuminate\Support\Str;
use App\Service\AddressService;
use App\Service\ActivityService;
use Auth;

class OrganisationService
{
    public function organisationCreateUpdate($request,$user){

        $obj['name']=$request['name'];
        $obj['user_id']=$user['id'];
        $obj['email']=$request['email'];
        $obj['mobile_no']=$request['mobile_no'];
        $obj['gst']=$request['gst'];
        $obj['company_type']=$request['company_type'];      // Business , Individual
        $obj['currency']=$request['currency'];
        $obj['symbol']=$request['symbol'];
        $obj['currency_entry_type']=$request['currency_entry_type']??'daily';  // daily , monthly --this is for entry currency rate
        $obj['language']=$request['language'];
        $obj['company_logo']=$request['company_logo'];
        $obj['logo_svg']=$request['logo_svg'];
        $obj['tax_type']=$request['tax_type'];     // 1 = GST , 2 = VAT

        // Address
        $obj['country_id']=$request['country_id'];
        $obj['state_id']=$request['state_id'];
        $obj['city_id']=$request['city_id'];
        $obj['address']=$request['address'];
        $obj['street1']=$request['street1'];
        $obj['street2']=$request['street2'];
        $obj['zipcode']=$request['zipcode'];

        // Add Company_logo
        // if ($request->file('logo')) {
        //     $photo = $request->file('logo');
        //     $filename = time() . '.' . $photo->getClientOriginalExtension();
        //     $path = public_path('uploads/company-logo');
        //     $photo->move($path, $filename);
        //     $obj['company_logo']= $filename;
        // }

        // Creating Object of address
        // $address=new AddressService;

        if(isset($request['id']) && $request['id']>0){

            try{

                $organisation=Organisation::where('id',$request['id'])->first();
                $organisation->update($obj);

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found

                return response()->json(['message' => 'Invalid Id found'], 404);

            }

            // Creating Activities
            $activity=new ActivityService;
            $activity->activityCreateUpdate('Organisation',$organisation['id'],'Updated');

            // $address->adreessCreateUpdate($request);
        }else{
            $organisation=Organisation::create($obj);

            // Creating Activities
            $activity=new ActivityService;
            $activity->activityCreateUpdate('Organisation',$organisation['id'],'Created');

            $organisation['organisation_id']=$this->generateRandomID();
            $organisation->update();

            // create Organisation Permission Roles
            $org_role=$this->createOrganisationRole($organisation);

            $user_organisation=UserOrganisation::where('user_id',$user['id'])->count();

            if($user_organisation==0){
                // Update owner organisation id
                $user['organisation_id']= $organisation['organisation_id'];
                $user['primary_organisation']= $organisation['organisation_id'];
                $user['active_organisation']= $organisation['organisation_id'];
                $user->update();
            }

            // create default Owner Role
            $user_org['user_id']=$user['id'];
            $user_org['is_owner']=1;
            $user_org['organisation_id']=$organisation['organisation_id'];
            $user_org['role']=$org_role['id'];

            UserOrganisation::create($user_org);

            // $address->adreessCreateUpdate($request);

        }
        
        return $organisation;
    }

    private function generateRandomID(){

        $unique = false;
    
        while (!$unique) {
            $random_string = Str::random(8);
            $random_string = strtoupper($random_string);
            $count = Organisation::where('organisation_id', $random_string)->count();
            if ($count == 0) {
                $unique = true;
            }
        }
    
        return $random_string;
    }


    public function createOrganisationRole($organisation){

        $permission=[
            'create'=>1,
            'edit'=>1,
            'delete'=>1
        ];

        $obj['organisation_id']=$organisation['organisation_id'];
        // $obj['user_id']=$organisation['user_id'];
        $obj['name']='Admin';
        $obj['items']=json_encode($permission);
        $obj['sales']=json_encode($permission);
        $obj['purchases']=json_encode($permission);
        $obj['accounts']=json_encode($permission);
        $obj['reports']=json_encode($permission);

        return OrganisationRolePermission::create($obj);
    }
   
}