<?php

namespace App\Service;
use App\Models\PaymentDetail;
use Log;
use Auth;

class PaymentDetailsService
{
    public function paymentDetailCreateUpdate($request, $user) {
        
        if (isset($request['payment_details'])) {
            $paymentDetails = $request['payment_details']; // Correctly retrieve insurance details
            $obj = [];
    
            $obj['payment_method'] = $paymentDetails['payment_method'] ?? null; // Check if key exists
            $obj['payment_terms'] = $paymentDetails['payment_terms']??null; // Default to 'Life'
            $obj['credit_limit'] = $paymentDetails['credit_limit'] ?? 0.0;
            $obj['currency'] = $paymentDetails['currency'] ?? null;
    
            $obj['user_id'] = $user['id'] ?? null; // Ensure user_id exists
    
            // Create and save the insurance details
            $payment = PaymentDetail::create($obj);

        }
    
        return true;
    }

}