<?php

namespace App\Service;
use DB;
use App\Models\User;
use App\Models\UserOrganisation;

class ProfileService
{

	public function getuser($id){
		$user = User::where('id',$id)
			->with('active_organisation','active_organisation.country:id,name',
				'active_organisation.city:id,name','active_organisation.state:id,name')
			->first();

		$user_organisation=UserOrganisation::where('user_id',$user['id'])
			->where('organisation_id',$user['active_organisation'])
			->with('roles')->first();

		if($user_organisation!=null){
			$user['permissions']=$user_organisation['roles'];
			$user['is_admin']=$user_organisation['is_owner']==1?true:false;
		}
		
		return $user;
	}


	public function createupdateProfile($user,$request){
		$data=[
			'name','mobile_no','customer_type','company_name','display_name','pan_no','tan_no',
			'payment_terms','gst_no','first_name','last_name','salutation','work_phone','is_customer','is_vendor',
			'place_of_supply','tax_preference','currency','customer_note','website','registration_type','upload_documents',
			'opening_balance','department','designation','remarks','business_leagal_name','departments','status',
			'gender','d_o_b','citizenship','blood_group','relation_id','relationship','photo','food_type','family_ids',
			'employee_ids','is_employee','user_expiry_date','account_id','category_type','is_logistics' ,'is_container_owner',
			'is_driver','logistic_provider_id','customer_pin',
			'nature_of_entity','vendor_type'
		];
		foreach ($data as $key => $value) {
			if(isset($request[$value]) && $request[$value]!=null && $request[$value]!=''){
				$user[$value]=$request[$value]??null;
			}
		}

		// $user=User::create($obj);
		return $user;
	}
}