<?php

namespace App\Service;
use DB;
use App\Models\User;
use App\Models\BillItem;
use App\Models\Item;
use App\Models\PurchaseOrderItem;

class PurchaseItemService
{

    public function saveItems($request,$transaction){
        
        foreach ($request['items'] as $key => $item) {
            // $data=[
            //     'item_id',
            //     'item_name',
            //     'quantity',
            //     'gross_amount',
            //     'rate',
            //     'unit_id',
            //     'tax_rate',
            //     'tax_amount',
            //     'discount_type',
            //     'discount',
            //     'final_amount',
            //     'item_remark',
            //     'discount',
            //     'is_service',
            //     'service_data',
            //     'type'
            // ];
            
            // foreach ($data as $key => $value) {
            //     if(isset($item[$value]) && $item[$value]!=null && $item[$value]!=''){
            //         $obj[$value]=$item[$value];
            //         $obj['transaction_id']=$transaction['id'];
            //     }
            // }

            $obj['item_id']=$item['item_id']??0;
            $obj['item_name']=$item['item_name']??null;
            $obj['quantity']=$item['quantity']??0;
            $obj['gross_amount']=$item['gross_amount']??0;
            $obj['rate']=$item['rate']??0;
            $obj['unit_id']=$item['unit_id']??0;
            $obj['tax_rate']=$item['tax_rate']??0;
            $obj['tax_amount']=$item['tax_amount']??0;
            $obj['discount_type']=$item['discount_type'];
            $obj['discount_percent']=$item['discount_percent']??null;
            $obj['discount']=$item['discount']??0;
            $obj['final_amount']=$item['final_amount']??0;
            $obj['item_remark']=$item['item_remark']??null;
            $obj['discount']=$item['discount']??0;
            $obj['is_service']=$item['is_service']??0;
            $obj['service_data']=$item['service_data']??null;
            $obj['type']=$item['type']??null;
            $obj['account_id']=$item['account_id']??null;

            $obj['transaction_id']=$transaction['id'];

            $new_item=null;

            // check if item is not created or not a service
            if(!isset($obj['item_id'])  && $obj['type']!='Service'){

                // creating New item
                $ob['name']=$obj['item_name'];
                $ob['unit']=$obj['unit_id']??0;
                $ob['price']=$obj['rate']??0;
                $ob['tax_rate']=$obj['tax_rate']??0;
                $ob['type']='Product';
                $ob['sale_acc_id']=53;
                $ob['purchase_acc_id']=30;
                $ob['tax_preference']=$obj['tax_rate']>0?1:2;
                
                $new_item=Item::create($ob);

                $obj['item_id']=$new_item['id'];
            }

            if($request['purchase_type']=='purchase_order'){

                $saleItem=PurchaseOrderItem::create($obj);
                
            }

            if($request['purchase_type']=='bills'){

                if(isset($obj['item_id']) && $obj['item_id']>0 && $obj['item_id']!=null){
                    $item=Item::where('id',$obj['item_id'])->first();
                    $obj['account_id']=$item['purchase_acc_id']??0;
                }

                // $transaction['total_tax']=$transaction['total_tax'] + (isset($obj['tax_amount']) ? $obj['tax_amount'] : 0);
                $transaction['total_gross_amount']=$transaction['total_gross_amount'] + (isset($obj['final_amount']) ? $obj['final_amount'] : 0);
    
                $saleItem=BillItem::create($obj);
            
            }
        }

        $transaction->update();
        
        return true;
        
    }
}