<?php

namespace App\Service;
use App\Models\User;
use Auth;
use Carbon\Carbon;
use App\Models\Company;

class StaticMaster
{

	// Transaction types or Entity Types
	public static $OPENING_STOCK_TYPE=1;
	public static $SALE_TRANSACTION_TYPE=2;
	public static $PURCAHSE_TRANSACTION_TYPE=3;
    public static $CREDIT_NOTE=4;
	public static $DEBIT_NOTE=5;
	public static $MODIFY_STOCK=6;
	public static $JOURNAL=7;
	public static $GRN_PURCHASE_TYPE=8;
	public static $MANUFACTURING_TRANSFER=9;
	public static $PRODUCTION_RAW=10;
	public static $PRODUCTION_SCRAP=11;
	public static $PRODUCTION_DAMAGE=12;
	public static $PRODUCTION_FINISHED_GOODS=13;
	public static $PRODUCTION_PACKAGING=14;
	public static $PAYMENTS_RECEIVED=15;    
	public static $PAYMENTS_MADE=16;        
	public static $EXPENSE=17;
	public static $INVOICE_PAYMENT=18;      
	public static $BILL_PAYMENT=19;			
	public static $DSR_TYPE=20;	
	public static $MICE_TYPE=21;		
	public static $WORKSHOP_TRANSFER=22;		
	public static $TMS_STOCK_TRANSFER=23;		
	public static $CREDIT_NOTE_PAYMENT=24;		
	public static $DEBIT_NOTE_PAYMENT=25;		
	public static $EXPENSE_PAYMENT=26;		
	public static $STOCK_TRANSFER_TYPE=27;		

	// Status of transactions
	public static $STATUS_DRAFT = 0; // draft status for transaction
	public static $STATUS_APPROVED = 1; // Approved
	public static $STATUS_REJECTED = 2; // sent to customer/client status for transaction and accepted
	public static $STATUS_COMPLETED = 3; // completed status for transaction
	public static $STATUS_OVERDUE = 4; // 
	

	// public static function getCurrentFinancialYear($organisation_id){
	// 	$today = Carbon::today();
	// 	$company = Organisation::where('organisation_id',$organisation_id)->first();
	// 	$startmonth = null;
	// 	if($company!=null){
	// 		$startmonth = $company['startmonthfy']; 
	// 	} else {
	// 		$startmonth = 4;
	// 	}
	// 	$currentmonth = $today->format('m');
	// 	$fy = $today->format('Y');
	// 	if($currentmonth<$startmonth){
	// 		$fy = $fy -1;
	// 	}
	// 	return $fy;
	// }

	function getFinancialYear()
	{
		$currentDate = Carbon::now();
		$year = $currentDate->year;
		
		return $year;
		
	}
	
	public static function getStartDayOfFinancialYear($companyid,$fy){
		$company = Company::where('companyid',$companyid)->first();
		$startmonth = null;
		if($company!=null){
			$startmonth = $company['startmonthfy']; 
		} else {
			$startmonth = 4;
		}
		$startday = Carbon::createfromformat('Y-m-d',$fy.'-'.$startmonth.'-1');
		return $startday;
	}

	public static function getLastDayOfFinancialYear($companyid,$fy){
		$company = Company::where('companyid',$companyid)->first();
		$endmonth = null;
		if($company!=null){
			$endmonth = $company['endmonthfy'];
			if($endmonth!=12){
				$fy = $fy + 1;
			}
			//dec is also 31 
		} else {
			$endmonth = 3;
			//march is also 31
			$fy = $fy + 1;
		}
		$lastday = Carbon::createfromformat('Y-m-d',$fy.'-'.$endmonth.'-31');
		return $lastday;
	}


	// Masters Labelid's
	public static $TAX_TYPE = 1; // draft status for transaction
	public static $UNITS = 2; // Approved
	public static $CUSTOMER_TYPE = 3; // sent to customer/client status for transaction and accepted
	public static $SALUTATION = 4; // completed status for transaction
	public static $ITEM_TYPE = 5; // cancelled status for transaction
	public static $TAX_PREFERENCE = 6; // cancelled status for transaction
	public static $REASON_TYPE = 7; // cancelled status for transaction
	public static $PAYMENT_TERMS = 8; // cancelled status for transaction
	public static $PAYMENT_MODE = 9; // cancelled status for transaction
	public static $DEPARTMENT = 10; // cancelled status for transaction
	public static $TRANSACTION_TYPES = 11; // cancelled status for transaction
	public static $CREDIT_DEBIT_NOTE_REASON = 12; // cancelled status for transaction
	public static $CHARGES = 13; // cancelled status for transaction
	public static $ROUTINGS = 14; // cancelled status for transaction
	public static $SCRAPS = 15; // cancelled status for transaction
	public static $CHALLAN_TYPES = 16; // cancelled status for transaction
	public static $GOODS_CONDITION_TYPE = 18; // cancelled status for transaction
	public static $TEST_PARAMETER = 19; // cancelled status for transaction


	// Accounts
	// ['accounts','account_groups','account_types']

	// HRMS Tables
	//  ['announcements','applicants','assing_shifts','attendances','clients','contacts','departments','designations',
	//	'education','employees','employee_healths','experiences','followers','holidays','job_openings','leaves','leave_masters',
	//  'my_files','performances','projects','quick_links','shifts','shift_masters']

	//Payroll
	// ['pay_slips','salary_components','salary_details','statutory_components']

	// Naksha Travels
	// ['accommodations','airports']


	// CMS Tables
	// [
	// 	'address',
	// 	'banks',
	// 	'blocks',
	// 	'cache',
	// 	'cms_item_details',
	// 	'cms_purchase_orders',
	// 	'container_activities',
	// 	'container_conditions',
	// 	'container_details',
	// 	'container_owners',
	// 	'container_statuses',
	// 	'container_types',
	// 	'dasboard_permissions',
	// 	'documents',
	// 	'document_types',
	// 	'failed_jobs',
	// 	'feedbacks',
	// 	'images',
	// 	'jobs',
	// 	'job_batches',
	// 	'load_on_trucks',
	// 	'logistic_providers',
	// 	'migrations',
	// 	'orders',
	// 	'placed_departure_order',
	// 	'ports',
	// 	'port_details',
	// 	'pre_arrival_departure',
	// 	'sessions',
	// 	'suppliers',
	// 	'tickets',
	// 	'trailers',
	// 	'users',
	// 	'user_history',
	// 	'vehicles',
	// 	'vehicle_brands',
	// 	'vehicle_trailers',
	// 	'vehicle_types',
	// 	'yards'
	// ]
	

	// Workshop Tables
	// ['job_cards','job_card_activities','job_card_parts','job_card_services','job_card_statuses']

	// TMS Tables
	// ['battery_details','battery_histories','battery_inspection_histories','battery_service_histories','battery_stocks',
	// rim_details,'rim_histories','rim_inspection_histories','rim_service_histories','rim_stocks','tyre_details',
	// 'tyre_histories','tyre_inspection_histories','tyre_service_histories','tyre_stocks',
	// 'tms_requestions','tms_requestion_items','tms_transaction_stores','trailers','trailer_histories',
	// 'trailer_installations','trailer_documents','vehicles','vehicle_documents','vehicle_trailers','vehicle_installations'],



	// App permission
	// "{\"accounting\":1,\"hrms\":1,\"manufacturing\":1,\"logistics\":0,\"cms\":0,\"tms\":0,\"legal\":0,\"mice_dsr\":0,\"payroll\":0,\"workshop\":0,\"container_owner\":0,\"fleet_tracking\":0,\"travel_agency\":0}"
}