<?php

namespace App\Service\Tms;
use App\Models\Tms\BatteryDetail;
use Log;
use Auth;
use Carbon\Carbon;

class BatteryService
{
    public function batteryCreateUpdate($request,$item){

        $obj = [];

        if(isset($request['battery_details'])){
        
            $battery = $request['battery_details'];

            $obj['item_id'] = $item['id']; 
            $obj['name'] = $item['name'];
            $obj['brand'] = $item['brand_name']??null;
            $obj['model'] = $battery['model']??null;
            $obj['voltage'] = $battery['voltage']??null;
            $obj['dry_weight'] = $battery['dry_weight']??null;
            $obj['cca'] = $battery['cca']??null;
            $obj['capacity_ah'] = $battery['capacity_ah']??null;
            $obj['reserve_capacity'] = $battery['reserve_capacity']??null;
            $obj['purchase_date'] = $battery['purchase_date']??null;
            $obj['purchase_cost'] = $battery['purchase_cost']??null;
            // $obj['installation_date'] = $battery['installation_date'];
            // $obj['vehicle_id'] = $battery['vehicle_id'];
            $obj['current_vehicle'] = $battery['current_vehicle']??null;
            $obj['mileage_at_installation'] = $battery['mileage_at_installation']??null;
            $obj['battery_condition'] = $battery['battery_condition']??null;
            $obj['warranty_type'] = $battery['warranty_type']??null;
            $obj['warranty_start_date'] = $battery['warranty_start_date'];
            $obj['warranty_end_date'] = $battery['warranty_end_date'];
            $obj['notes_comments'] = $battery['notes_comments']??null;
            $obj['status'] = $battery['status']??'Active';
            // $obj['location_status'] = $battery['location_status'];
            $obj['preferred_vehicles'] = $battery['preferred_vehicles']??null;
            $obj['json_data'] = $battery['json_data']??null;

            if(isset($battery['id']) && $battery['id']>0){
                BatteryDetail::where('id', $battery['id'])->update($obj);
            }else{
                BatteryDetail::create($obj);
            }
        }

        return true;
    }

}













