<?php

namespace App\Service\Tms;
use Log;
use Auth;
use Carbon\Carbon;
use App\Models\Tms\Trailer;
use App\Models\Tms\TyreStock;
use App\Models\Tms\TyreHistory;
use App\Models\Tms\Trailers\TrailerInstallation;
use DB;

class TrailerTyreService
{
    public function createTrailerTyre($rows){

            Log::info($rows);

            $tyreStock = TyreStock::where('tyre_id', $rows['tyre_id'])->first();
            if (!$tyreStock) {
                $obj = [    
                    'tyre_id' => $rows['tyre_id'],
                    'tyre_detail_id' =>0,
                    'item_id' => 0,
                    'brand' => $rows['make'] ?? null,
                    'tyre_pattern' => $rows['pattern'] ?? null,
                    'tread_depth' => $rows['fitted_mm'] ?? null,
                    'status' => 'Active'
                ];
                $tyreStock = TyreStock::create($obj);
            }

            

            // Log::info($tyreStock);

            //Tyre history Create
            // $obj1['tyre_id'] = $tyreStock['id']; // required – no default  //From the Tyre Stock lIst
            // $obj1['date'] = $rows['installation_date'] ?? null;
            // $obj1['moved_to'] = 'Tms Store';
            // $obj1['moved_from'] = 'Import'; // From the Tyre Stock List
            // $obj1['trailer_id'] =0;
            // $obj1['remark'] = 'Tyre with Tyre Id: '.$rows['tyre_id'].' Imported to TMS Store';
            // $obj1['attachment'] =null;

            // $tyreHistory = TyreHistory::create($obj1);

            // Log::info($tyreStock);

            // Fetch the trailer
            $trailer = Trailer::where('trailer_id',$rows['fleet_no'])->first();

            if (!$trailer) {
                Log::info([
                    'success' => false,
                    'message' => 'Trailer not found',
                    'trailer_no'=> $rows['fleet_no']
                ]);
                return ;
            }

            $positionMap=null;
            if($trailer['model']=='SUPERLINK'){
                $positionMap = [
                    1  => 'FL0',
                    2  => 'FL1',
                    3  => 'FR0',
                    4  => 'FR1',
                    5  => 'RL0',
                    6  => 'RL1',
                    7  => 'RRO',
                    8  => 'RR1',
                    9  => 'TL0',
                    10 => 'TFL1',
                    11 => 'TFR0',
                    12 => 'TFR1',
                    13 => 'TRL0',
                    14 => 'TRL1',
                    15 => 'TRR0',
                    16 => 'TRR1',
                    17 => 'TSW1',
                    18 => 'TSW2',
                ];
            }

            if($trailer['model']=='TRI-AXLE'){
                $positionMap = [
                    1  => 'FL0',
                    2  => 'FL1',
                    3  => 'FR0',
                    4  => 'FR1',
                    5  => '1L0',
                    6  => '1L1',
                    7  => '1R0',
                    8  => '1R1',
                    9  => 'RL0',
                    10 => 'RL1',
                    11 => 'RR0',
                    12 => 'RR1',
                    13 => 'SW1',
                    14 => 'SW2'
                ];
            }

            // Log::info($positionMap[$rows['position']]);

            // Log::info("checking the tyre stock before update");
            // Log::info($tyreStock);

            // Update the tyre stock record
            $tyreStock->installation_date = $rows['installation_date'] ?? null;
            $tyreStock->trailer_id = $trailer->id ?? 0;
            $tyreStock->location_status = 'Trailer';
            $tyreStock->position_on_trailer = $positionMap[$rows['position']] ?? null;
            $tyreStock->save();

            // Log::info("checking the tyre stock After update");
            // Log::info($tyreStock);

            // Save the trailer tyre History record
            $history = new TyreHistory;
            $history['tyre_id'] = $tyreStock->id;
            $history['date'] = $rows['installation_date'] ?? null;
            $history['moved_from'] = 'Store';
            $history['moved_to'] = 'Trailer';
            $history['trailer_id'] = $trailer->id;
            $history['attachment'] =null;
            $history['remark'] = 'Tyre installed on trailer ' . $trailer['trailer_id'] . ' at position ' . $positionMap[$rows['position']].' which is : '.$rows['position'];
            $history->save();

            // Save the trailer installation record
            $installation = new TrailerInstallation;
            $installation['date'] = $rows['installation_date'] ?? null;
            $installation['trailer_id'] = $trailer->id;
            $installation['type'] = 'tyre';
            $installation['type_id'] = $tyreStock->id;
            $installation['position'] = $positionMap[$rows['position']];
            $installation->save();

            // Log::info($installation);

            return ;

    }

}