<?php

namespace App\Service\Tms;
use App\Models\Tms\TyreDetail;
use Log;
use Auth;
use Carbon\Carbon;

class TyreService
{
    public function tyreCreateUpdate($request,$item){

        $obj = [];

        if(isset($request['tyre_details'])){
        
            $tyre_detail = $request['tyre_details'];

            $obj['item_id'] = $item['id'];

            $obj['warranty_type'] = $tyre_detail['warranty_type'];
            $obj['warranty_start_date'] = $tyre_detail['warranty_start_date'];
            $obj['warranty_end_date'] = $tyre_detail['warranty_end_date'];
            $obj['name'] = $item['name'];
            $obj['identity'] = $tyre_detail['identity'];
            $obj['tread_depth'] = $tyre_detail['tread_depth'];
            $obj['maximum_tread_depth'] = $tyre_detail['maximum_tread_depth']; 
            $obj['pressure'] = $tyre_detail['pressure']??null;
            $obj['rolling_km'] = $tyre_detail['rolling_km']??0; 
            $obj['maximum_rolling_km'] = $tyre_detail['maximum_rolling_km']??0;  
            $obj['load_pressure_information'] = $tyre_detail['load_pressure_information']??null;
            $obj['indicated_exterior'] = $tyre_detail['indicated_exterior'];
            $obj['type_of_construction'] = $tyre_detail['type_of_construction'];
            $obj['tyre_sections_width_mm'] = $tyre_detail['tyre_sections_width_mm'];
            $obj['section_height_to_section_width_ratio'] = $tyre_detail['section_height_to_section_width_ratio'];
            $obj['rim_diameter_inches'] = $tyre_detail['rim_diameter_inches'];
            $obj['load_capacity_index'] = $tyre_detail['load_capacity_index'];
            $obj['speed_rating'] = $tyre_detail['speed_rating'];
            $obj['load_rating'] = $tyre_detail['load_rating'];
            $obj['tyre_type'] = $tyre_detail['tyre_type'];
            $obj['preferred_vehicles'] = $tyre_detail['preferred_vehicles']??null;
            $obj['brand'] = $item['brand_name']??null;
            $obj['model'] = $tyre_detail['model']??null;
            $obj['currency'] = $tyre_detail['currency']??null;
            $obj['tubeless'] = $tyre_detail['tubeless']??null;
            $obj['attachment'] = $tyre_detail['attachment']??null;
            $obj['quantity'] = $tyre_detail['quantity']??0;
            $obj['remarks'] = $tyre_detail['remarks']??null;
            $obj['json_data'] = $tyre_detail['json_data']??null;
            $obj['tyre_pattern'] = $tyre_detail['tyre_pattern']??null;
    
            $obj['status'] = $tyre_detail['status']??'Active';

            if(isset($tyre_detail['id']) && $tyre_detail['id'] >0){
                TyreDetail::where('id', $tyre_detail['id'])->update($obj);
            }else{
                TyreDetail::create($obj);
            }
    
        }

        return true;
    }

}













