<?php

namespace App\Service\Tms;
use App\Models\Tms\Vehicle;
use Log;
use Auth;
use Carbon\Carbon;

class VehicleService
{
    public function vehicleCreateUpdate($request,$item){

        $obj = [];

        if(isset($request['vehicle_details'])){
        
            $vehicle= $request['vehicle_details'];

            $obj['item_id'] = $item['id'];
            $obj['vehicle_id'] = $vehicle['vehicle_id'];
            $obj['make'] = $vehicle['make'];
            $obj['model'] = $vehicle['model'];
            $obj['year'] = $vehicle['year'];
            $obj['vin_number'] = $vehicle['vin_number'];
            $obj['registration_number'] = $vehicle['registration_number'];  
            $obj['title_status'] = $vehicle['title_status'];
            $obj['fuel_type'] = $vehicle['fuel_type'];
            $obj['engine_type'] = $vehicle['engine_type'];
            $obj['transmission_type'] = $vehicle['transmission_type'];
            $obj['color'] = $vehicle['color'];
            $obj['mileage'] = $vehicle['mileage'];
            $obj['purchase_date'] = $vehicle['purchase_date']?? Carbon::now()->format('Y-m-d');
            $obj['purchase_price'] = $vehicle['purchase_price']??0;
            $obj['owner_name'] = $vehicle['owner_name']?? null;
            $obj['owner_contact'] = $vehicle['owner_contact']?? null;
            $obj['gps_device_id'] = $vehicle['gps_device_id']?? null;
            $obj['vehicle_type'] = $vehicle['vehicle_type']??null;
            $obj['axle_tyre_configuration'] = $vehicle['axle_tyre_configuration']??null;
            $obj['no_of_wheels'] = $vehicle['no_of_wheels']??0;
            $obj['axle_configuration'] = $vehicle['axle_configuration']??null;
            $obj['vehicle_class'] = $vehicle['vehicle_class']??null;
            $obj['license_renewal_date'] = $vehicle['license_renewal_date']??null;
            $obj['emissions_testing_date'] = $vehicle['emissions_testing_date']??null;
            $obj['emissions_compliance'] = $vehicle['emissions_compliance']??null;
            $obj['notes_comments'] = $vehicle['notes_comments']??null;
            $obj['qr_code'] = $vehicle['qr_code']??null;
            $obj['json_data'] = $vehicle['json_data']??null;
        
            Vehicle::create($obj);
        }

        return true;
    }

}