<?php

namespace App\Service\Tms;
use Log;
use Auth;
use Carbon\Carbon;
use App\Models\Tms\Vehicle;
use App\Models\Tms\TyreStock;
use App\Models\Tms\TyreHistory;
use App\Models\Tms\Vehicles\VehicleInstallation;
use DB;

class VehicleTyreService
{
    public function createVehicleTyre($rows){

            Log::info($rows);

            $existingTyre = TyreStock::where('tyre_id', $rows['tyre_id'])->first();
            if ($existingTyre) {
                Log::info([
                    'success' => false,
                    'message' => 'Tyre with ID already exists',
                    'data' => $existingTyre
                ]);
                return ;
            }

            // Creating the Tyre Stock
            $obj = [    
                'tyre_id' => $rows['tyre_id'],
                'tyre_detail_id' =>0,
                'item_id' => 0,
                'brand' => $rows['make'] ?? null,
                'tyre_pattern' => $rows['pattern'] ?? null,
                'tread_depth' => $rows['fitted_mm'] ?? null,
                'status' => 'Active'
            ];
            $tyreStock = TyreStock::create($obj);

            // Log::info($tyreStock);

            //Tyre history Create
            $obj1['tyre_id'] = $tyreStock['id']; // required – no default  //From the Tyre Stock lIst
            $obj1['date'] = $rows['installation_date'] ?? null;
            $obj1['moved_to'] = 'Tms Store';
            $obj1['moved_from'] = 'Import'; // From the Tyre Stock List
            $obj1['vehicle_id'] =0;
            $obj1['remark'] = 'Tyre with Tyre Id: '.$rows['tyre_id'].' Imported to TMS Store';
            $obj1['attachment'] =null;

            $tyreHistory = TyreHistory::create($obj1);

            // Log::info($tyreStock);

            // Fetch the vehicle
            $vehicle = Vehicle::where('vehicle_id',$rows['fleet_no'])->first();
            // Log::info($vehicle);

            if (!$vehicle) {
                Log::info([
                    'success' => false,
                    'message' => 'Vehicle not found',
                    'vehicle_no'=> $rows['fleet_no']
                ]);
                return ;
            }

            $positionMap = [
                1  => 'FL0',
                2  => 'FR0',
                3  => '1L0',
                4  => '1L1',
                5  => '1R0',
                6  => '1R1',
                7  => 'RL0',
                8  => 'RL1',
                9  => 'RR0',
                10 => 'RR1'
            ];

            // Log::info($positionMap[$rows['position']]);

            // Log::info("checking the tyre stock before update");
            // Log::info($tyreStock);

            // Update the tyre stock record
            $tyreStock->installation_date = $rows['installation_date'] ?? null;
            $tyreStock->vehicle_id = $vehicle->id ?? 0;
            $tyreStock->location_status = 'Vehicle';
            $tyreStock->position_on_vehicle = $positionMap[$rows['position']] ?? null;
            $tyreStock->save();

            // Log::info("checking the tyre stock After update");
            // Log::info($tyreStock);

            // Save the vehicle tyre History record
            $history = new TyreHistory;
            $history['tyre_id'] = $tyreStock->id;
            $history['date'] = $rows['installation_date'] ?? null;
            $history['moved_from'] = 'Store';
            $history['moved_to'] = 'Vehicle';
            $history['vehicle_id'] = $vehicle->id;
            $history['attachment'] =null;
            $history['remark'] = 'Tyre installed on vehicle ' . $vehicle['vehicle_id'] . ' at position ' . $positionMap[$rows['position']].' which is : '.$rows['position'];
            $history->save();

            // Save the vehicle installation record
            $installation = new VehicleInstallation;
            $installation['date'] = $rows['installation_date'] ?? null;
            $installation['vehicle_id'] = $vehicle->id;
            $installation['type'] = 'tyre';
            $installation['type_id'] = $tyreStock->id;
            $installation['position'] = $positionMap[$rows['position']];
            $installation->save();

            // Log::info($installation);

            return ;

    }

}