<?php

namespace App\Service;
use App\Models\Transaction;
use App\Service\StaticMaster;
use Auth;
use Log;
use Carbon\Carbon;

class TransactionService
{
    public function createTransaction($account_id,$transaction,$user_id,$entity_type,$transaction_type,$debit,$credit){
        $obj['transaction_id']=$transaction['id'];
        $obj['transaction_date']=$transaction['transaction_date'];
        $obj['transaction_type']=$transaction_type;
        $obj['customer_id']=$transaction['customer_id']??0;       
        $obj['vendor_id']=$transaction['vendor_id']??0;        
        $obj['account_id']=$account_id;
        $obj['entity_type']=$entity_type;
        $obj['debit']=$debit??0.0;
        $obj['credit']=$credit??0.0;
        $obj['warehouse_id']=$transaction['warehouse_id']??0;
        $obj['fy']=$transaction['fy'];
        $obj['notes']=$transaction['notes']??null;
        // $obj['entity_no']=$details['invoice_no'];    //dsr_no
        // $obj['reference_no']=$details['invoice_no'];

        $transaction=Transaction::create($obj);

        return $transaction;
    }

    // Against bill or invoice payment account entry
    public function create_against_payment_Transaction($account_id,$transaction,$payment,$entity_type,$transaction_type,$debit,$credit){
        $obj['transaction_id']=$transaction['id'];
        $obj['transaction_date']=$transaction['transaction_date'];
        $obj['transaction_type']=$transaction_type;
        $obj['customer_id']=$transaction['customer_id']??0;       
        $obj['vendor_id']=$transaction['vendor_id']??0;        
        $obj['account_id']=$account_id;
        $obj['entity_type']=$entity_type;
        $obj['debit']=$debit??0.0;
        $obj['credit']=$credit??0.0;
        $obj['warehouse_id']=$transaction['warehouse_id']??0;
        $obj['fy']=$transaction['fy'];
        $obj['notes']=$payment['bill_no']??$payment['invoice_no'];

        $transaction=Transaction::create($obj);

        return $transaction;
    }

    // Journal Transaction 
    public function createJournalTransaction($transaction,$entry){
        $obj['transaction_id']=$entry['id'];
        $obj['transaction_date']=$transaction['transaction_date'];
        $obj['transaction_type']=StaticMaster::$JOURNAL;
        $obj['account_id']=$entry['account_id'];
        $obj['entity_type']='journal';
        $obj['debit']=$entry['debit']??0;
        $obj['credit']=$entry['credit']??0;
        $obj['warehouse_id']=$transaction['warehouse_id']??0;
        $obj['fy']=$transaction['fy'];
        $obj['notes']=$entry['description'];

        Log::info($obj);

        $transaction=Transaction::create($obj);

        // Updating Accounts Balance
        // $this->updateAccountsBalance($entry['account_id'],$entry['debit'],$entry['credit']);

        return $transaction;
    }

    // DSR And Mice Transactions for suppliers
    public function dsr_mice_createTransaction($account_id,$transaction,$details,$user_id,$entity_type,$transaction_type,$debit,$credit){
        $today_date=Carbon::now()->format('Y-m-d');
        
        $obj['transaction_id']=$details['transaction_id'];     //dsr_id
        $obj['transaction_date']=$today_date;
        $obj['transaction_type']=$transaction_type;   //20
        $obj['customer_id']=$transaction['customer_id']??0;       
        $obj['vendor_id']=$transaction['supplier_id']??0;        
        $obj['account_id']=$account_id;
        $obj['entity_type']=$entity_type;    //dsr
        $obj['debit']=$debit??0;
        $obj['credit']=$credit??0;
        $obj['warehouse_id']=$transaction['warehouse_id']??0;
        $obj['fy']=$transaction['fy']??2025;     //2025
        $obj['entity_no']=$details['invoice_no'];    //dsr_no
        $obj['reference_no']=$details['invoice_no'];
        $obj['notes']=$details['service'].' Service under passenger "'.$details['passenger_name'].'" having Invoice No.="'.$details['invoice_no'].'"';

        $transaction=Transaction::create($obj);

        return $transaction;
    }

     // DSR And Mice Transactions for Customers
     public function dsr_mice_customer_createTransaction($account_id,$transaction,$customer_id,$entity_type,$transaction_type,$debit,$credit){
        $today_date=Carbon::now()->format('Y-m-d');
        
        $obj['transaction_id']=$transaction['id'];     //dsr_id
        $obj['transaction_date']=$today_date;
        $obj['transaction_type']=$transaction_type;   //20
        $obj['customer_id']=$customer_id??0;       
        $obj['vendor_id']=0;        
        $obj['account_id']=$account_id;
        $obj['entity_type']=$entity_type;    //dsr
        $obj['entity_no']=$transaction['dsr_no'];    //dsr_no
        $obj['reference_no']=$transaction['dsr_no'];
        $obj['debit']=$debit??0;
        $obj['credit']=$credit??0;
        $obj['warehouse_id']=$transaction['warehouse_id']??0;
        $obj['fy']=$transaction['fy']??2025;     //2025
        $obj['notes']=$transaction['dsr_no'];
        
        
        $transaction=Transaction::create($obj);

        return $transaction;
    }

     // DSR And Mice Single Transactions for ccustomer vat transaction
     public function dsr_mice_vat_customer_createTransaction($account_id,$transaction,$details,$customer_id,$entity_type,$transaction_type,$debit,$credit){
        $today_date=Carbon::now()->format('Y-m-d');
        
        $obj['transaction_id']=$details['transaction_id'];     //dsr_id
        $obj['transaction_date']=$today_date;
        $obj['transaction_type']=$transaction_type;   //20
        $obj['customer_id']=$customer_id??0;       
        $obj['vendor_id']=0;        
        $obj['account_id']=$account_id;
        $obj['entity_type']=$entity_type;    //dsr
        $obj['debit']=$debit??0;
        $obj['credit']=$credit??0;
        $obj['warehouse_id']=$transaction['warehouse_id']??0;
        $obj['fy']=$transaction['fy']??2025;     //2025
        $obj['entity_no']=$details['invoice_no'];    //dsr_no
        $obj['reference_no']=$details['invoice_no'];
        $obj['notes']=$details['service'].' Service under passenger "'.$details['passenger_name'].'" having Invoice No.="'.$details['invoice_no'].'"';

        $transaction=Transaction::create($obj);

        return $transaction;
    }
}