<?php

namespace App\Service\Trip;
use App\Models\Activity;
use Log;
use Auth;
use Carbon\Carbon;
use App\Models\Trip\TripContainer;
use App\Models\Trip\TripItem;
use App\Models\Trip\TripDeliveryPoint;
use App\Models\Trip\TripPickupPoint;
use App\Models\Trip\TripExpense;
use App\Models\Trip\TripStatus;

class TripService
{

    // Create Trip Containers
    public function containersCreateUpdate($request,$trip_booking){

        if (!empty($request['container_details'])) {

            foreach ($request['container_details'] as $key => $value) {
                $obj = [];
                $isEmptyContainer = true; // Flag to check if container data is empty

                $obj['trip_booking_id']=$trip_booking['id'];

                // Required fields
                $obj['container_owner_id'] = $value['container_owner_id'] ?? 0;
                $obj['container_id'] = $value['container_id'] ?? null;
                $obj['container_type'] = $value['container_type'] ?? 0;

                $obj['internal_dimension'] = $value['internal_dimension'] ?? null;
                $obj['door_opening'] = $value['door_opening'] ?? null;
                $obj['cubic_capacity'] = $value['cubic_capacity'] ?? null;
                $obj['cargo_weight'] = $value['cargo_weight'] ?? null;

                // Other fields
                $obj['container_status'] = $value['container_status'] ?? null;
                $obj['container_condition'] = $value['container_condition'] ?? null;
                $obj['seal_no'] = $value['seal_no'] ?? null;

                $obj['is_megamarket'] = $value['is_megamarket'] ?? 0;

                // Images
                $obj['attachments'] = $value['attachments'] ?? null;

                // Check if at least one field is set (excluding order_id)
                foreach ($obj as $field => $fieldValue) {
                    if (!is_null($fieldValue) && $field !== 'order_id') {
                        $isEmptyContainer = false;
                        break;
                    }
                }

                // Create Container Detail
                $containerDetail = TripContainer::create($obj);

                // Skip this container if all values are empty
                if ($isEmptyContainer) {
                    continue;
                }

            }

            return true;
        } else {
            return false; // Return empty array if no container details are provided
        }
      
    }

    // Create Trip Item
    public function tripItemsCreate($request,$trip_booking){

        if (!empty($request['item_details'])) {

            foreach ($request['item_details'] as $key => $value) {
                $obj = [];

                $obj['item_id']=$value['item_id']??0;
                $obj['item_name']=$value['item_name']??null;
                $obj['unit']=$value['unit']??null;
                $obj['quantity']=$value['quantity']??0.0;
                $obj['weight']=$value['weight']??0;
                $obj['tax_rate']=$value['tax_rate']??0.0;
                $obj['item_remark']=$value['item_remark']??null;
                $obj['is_megamarket']=$value['is_megamarket']??0;  

                $obj['trip_booking_id']=$trip_booking['id'];

                TripItem::create($obj);
                
            }
            return true;

        }
        else {
            return false; // Return empty array if no item details are provided
        }
    }

    // Create Trip Delivery Point
    public function tripDeliveryPointCreate($request,$trip_booking){

        if (!empty($request['delivery_point_details'])) {

            foreach ($request['delivery_point_details'] as $key => $value) {
                $obj = [];

                $obj['trip_booking_id']=$trip_booking['id'];

                $obj['expected_date']=$value['expected_date']??null;
                $obj['address_line1']=$value['address_line1']??null;
                $obj['address_line2']=$value['address_line2']??null;
                $obj['city_id']=$value['city_id']??0;
                $obj['state_id']=$value['state_id']??0;
                $obj['country_id']=$value['country_id']??0;
                $obj['zipcode']=$value['zipcode']??null;
                $obj['country_name']=$value['country_name']??null;
                $obj['state_name']=$value['state_name']??null;
                $obj['city_name']=$value['city_name']??null;
                $obj['distance']=$value['distance']??null;
                $obj['remarks']=$value['remarks']??null;  //in km
                $obj['is_megamarket']=$value['is_megamarket']??0;  //in km
                

                TripDeliveryPoint::create($obj);
                
            }
            return true;

        }
        else {
            return false; // Return empty array if no item details are provided
        }
    }

    // Create Trip Pickup Point
    public function tripPickupPointCreate($request,$trip_booking){

        if (!empty($request['pickup_point_details'])) {

            foreach ($request['pickup_point_details'] as $key => $value) {
                $obj = [];

                $obj['trip_booking_id']=$trip_booking['id'];

                $obj['expected_date']=$value['expected_date']??null;
                $obj['address_line1']=$value['address_line1']??null;
                $obj['address_line2']=$value['address_line2']??null;
                $obj['city_id']=$value['city_id']??0;
                $obj['state_id']=$value['state_id']??0;
                $obj['country_id']=$value['country_id']??0;
                $obj['zipcode']=$value['zipcode']??null;
                $obj['distance']=$value['distance']??null;
                $obj['country_name']=$value['country_name']??null;
                $obj['state_name']=$value['state_name']??null;
                $obj['city_name']=$value['city_name']??null;
                $obj['remarks']=$value['remarks']??null;  //in km
                $obj['is_megamarket']=$value['is_megamarket']??0;  //in km

                TripPickupPoint::create($obj);
                
            }
            return true;

        }
        else {
            return false; // Return empty array if no item details are provided
        }
    }

    //Create Trip Expenses
    public function tripExpensesCreate($request,$trip_booking){

        if (!empty($request['trip_expenses'])) {

            foreach ($request['trip_expenses'] as $key => $value) {
                $obj = [];

                $obj['trip_booking_id']=$trip_booking['id'];

                $obj['account_id']=$value['account_id']??0;   //Select Expense Account
                $obj['amount']=$value['amount']??0.0;
                $obj['vendor_id']=$value['vendor_id']??0.0;
                $obj['customer_id']=$value['customer_id']??0.0;
                $obj['paid_by_id']=$value['paid_by_id']??0.0;   //Select Paid By Account
                $obj['expense_remark']=$value['expense_remark']??null;
                $obj['user_type']=$value['user_type']??null;

                TripExpense::create($obj);
                
            }
            return true;

        }
        else {
            return false; // Return empty array if no item details are provided
        }
    }


    // Creating Trip From the departure
    public function createTripDeparture($departure, $container_details){

        $sequence=new SequenceService();

        $obj['trip_booking_no'] =$sequence->getSequence('trip_booking') ?? null;
        $obj['trip_date_time'] = Carbon::now()->format('Y-m-d');  // Date
        $obj['trip_type'] = 2;  // 1 =arrival 2=departure

        $obj['customer_type'] = $request['customer_type'] ?? null;  // 1=in=bond, 2=out-bond
        $obj['customer_id'] = $request['customer_id'] ?? 0;  // Customer ID
        $obj['purchase_order_id'] = $request['purchase_order_id'] ?? 0;  // Purchase Order ID
        $obj['referal'] = $request['referal'] ?? null;  
        $obj['attachments'] = $departure['documents'] ?? null;  

        // Consigment Type
        $obj['consignment_type'] = $request['consignment_type'] ?? null;  // 1=ship, 2=road , 3=air , 4=rail
        $obj['consignment_json'] = $request['consignment_json'] ?? null;  // Consignment ID

        // Logistics Provider
        $obj['logistics_provider_id'] = $departure['logistic_provider_id'] ?? 0;
        $obj['driver_id'] = $departure['driver_id'] ?? null;
        $obj['driver_license_no'] = $departure['driver_license_no'] ?? null;

        // Vehicle Details
        $obj['vehicle_type'] = $departure['vehicle_type'] ?? null;
        $obj['vehicle_id'] = $departure['vehicle_id'] ?? null;
        $obj['starting_point'] = null;

        $trip_booking = TripBooking::create($obj);
    }


}