<?php

namespace App\Service\cms;

use DB;
use App\Models\cms\ContainerDetail;
use Illuminate\Support\Facades\Storage;
use App\Service\cms\ImageService;
use Log;

class ContainerDetailsService
{
    public function createOrderContainer($request)
    {
        if (!empty($request['container_details'])) {
            $order_container_id = [];

            foreach ($request['container_details'] as $key => $value) {
                $obj = [];
                $isEmptyContainer = true; // Flag to check if container data is empty

                // Required fields
                $obj['order_id'] = $request['order_id'] ?? $value['order_id'] ?? 0;
                $obj['container_owner_id'] = $value['container_owner_id'] ?? 0;
                $obj['container_owner_name'] = $value['container_owner_name'] ?? null;
                $obj['container_id'] = $value['container_id'] ?? null;
                $obj['container_type'] = $value['container_type'] ?? 0;

                $obj['yard_id'] = $value['yard_id'] ?? 0;
                $obj['block_id'] = $value['block_id'] ?? 0;

                // Auto-fetched fields (set null if not provided)
                $obj['internal_dimension'] = $value['internal_dimension'] ?? null;
                $obj['door_opening'] = $value['door_opening'] ?? null;
                $obj['cubic_capacity'] = $value['cubic_capacity'] ?? null;
                $obj['cargo_weight'] = $value['cargo_weight'] ?? null;

                // Other fields
                $obj['container_status'] = $value['container_status'] ?? null;
                $obj['container_condition'] = $value['container_condition'] ?? null;

                // Order Status
                $obj['order_status']= $request['order_type'];

                // Images
                $obj['images'] = $value['images'] ?? null;
                $obj['attachments'] = $value['attachments'] ?? null;

                // Check if at least one field is set (excluding order_id)
                foreach ($obj as $field => $fieldValue) {
                    if (!is_null($fieldValue) && $field !== 'order_id') {
                        $isEmptyContainer = false;
                        break;
                    }
                }

                // Set Status based on Order Type
                if ($request['order_type'] == 'pre_departure') {

                    $obj['status'] = "ongoing";

                } elseif ($request['order_type'] == 'departure') {

                    $obj['status'] = "process";

                }  elseif ($request['order_type'] == 'arrival') {

                    $obj['status'] = "pending";

                } elseif ($request['order_type'] == 'pre_arrival') {

                    $obj['status'] = "pending";

                }

                // Skip this container if all values are empty
                if ($isEmptyContainer) {
                    continue;
                }

                // Create or Update Container Detail
                if(isset($value['id']) && $value['id'] > 0){
                    Log::info($value['container_id'].":Update Container Detail :".$value['id']);

                    $containerDetail = ContainerDetail::where('id', $value['id'])->first();
                    if($containerDetail){
                        $containerDetail->update($obj);
                    }else{

                        Log::info("Create Container Detail , as container detial not found :".$value['container_id']);
                        // Create Container Detail
                        $containerDetail = ContainerDetail::create($obj);
                    }
                }else{
                    Log::info("Create Container Detail with container iD:".$value['container_id']);
                    // Create Container Detail
                    $containerDetail = ContainerDetail::create($obj);
                }
              
                array_push($order_container_id, $containerDetail['id']);
            }

            return $order_container_id;
        } else {
            return []; // Return empty array if no container details are provided
        }
    }

    public function updateContainerDetail($request)
    {
        if (isset($request['container_details'])) {

            $order_container_id = [];
            foreach ($request['container_details'] as $key => $value) {

                // if existing container exists
                if (isset($value['order_container_id'])) {

                    $containerDetail = ContainerDetail::where('id', $value['order_container_id'])->first();
                    // dd($containerDetail);
                    
                    $obj['container_owner_id'] = $value['container_owner_id']??0;
                    $obj['container_id'] = $value['container_id'];
                    $obj['container_type'] = $value['container_type'];
                    $obj['internal_dimension'] = $value['internal_dimension'];
                    $obj['door_opening'] = $value['door_opening'];
                    $obj['cubic_capacity'] = $value['cubic_capacity'];
                    $obj['cargo_weight'] = $value['cargo_weight'];
                    $obj['container_status'] = $value['container_status'];
                    $obj['container_condition'] = $value['container_condition'];
                    $obj['images'] = $value['images'];

                    if($containerDetail){
                        $containerDetail->update($obj);
                        array_push($order_container_id, $containerDetail['id']);
                    }

                    // $image = 'images' . $key;

                    // $imageservice = new ImageService;
                    // $imageservice->addImage($request->$image, $request['order_container_id'][$key], $request['order_type']);
                } else {

                    if (isset($value)) {
                        $obj['container_owner_id'] = $value['container_owner_id']?? 0;
                        $obj['container_id'] = $value['container_id'];
                        $obj['container_type'] = $value['container_type'];
                        $obj['internal_dimension'] = $value['internal_dimension'];
                        $obj['door_opening'] = $value['door_opening'];
                        $obj['cubic_capacity'] = $value['cubic_capacity'];
                        $obj['cargo_weight'] = $value['cargo_weight'];
                        $obj['container_status'] = $value['container_status'];
                        $obj['container_condition'] = $value['container_condition'];
                        // $obj['order_id']= $orderid;
                        $obj['images'] = $value['images'];

                        if ($request['order_type'] == 'pre_departure') {
                            $obj['status'] = "ongoing";
                        }
                        if ($request['order_type'] == 'departure') {
                            $obj['status'] = "process";
                        }

                        $containerDetail = ContainerDetail::create($obj);

                        array_push($order_container_id, $containerDetail['id']);
                    }
                }
            }

            return $order_container_id;
        }
        
    }
}
