<?php

namespace App\Service\cms;
use DB;
use App\Models\cms\PreArrivalDeparture;
use Carbon\Carbon;
use Log;

class PreArrivalService
{
    // create pre Arrival Order
    public function savePreArrival($request){

        $data=[
            'date',
            'pre_arrival_id',
            'order_type',
            'yard_id',
            'block_id',
            'logistic_provider_id',
            'vehicle_type',
            'vehicle_no',
            'contact_person',
            'phone_number',
            'arrival_departure_address',
            'client_name',
            'client_email',
            'client_phoneno',
            'address',
            'remarks',
            'driver_name',
            'driver_license_no',
            'driver_contact_no',
            'documents',
            'driver_id'
        ];
        
        $obj = [];
		foreach ($data as $key => $value) {
			if(isset($request[$value]) && $request[$value]!=null && $request[$value]!=''){
				$obj[$value]=$request[$value];
			}
		}
        // $obj['order_id']=$orders->id;
        if($request['id'] > 0){
            $prearrival=PreArrivalDeparture::where('id', $request['id'])->where('order_type','pre_arrival')
                ->first();
                
            $prearrival->update($obj);

        } else {
            $prearrival=PreArrivalDeparture::create($obj);
        }

        return $prearrival;
    }
    
    // Create Arrived Order
    public function saveArrival($request){

        $data=[
            'date',
            'arrival_id',
            'order_type',
            'yard_id',
            'block_id',
            'logistic_provider_id',
            'vehicle_id',
            'vehicle_type',
            'vehicle_no',
            'contact_person',
            'phone_number',
            'arrival_departure_address',
            'client_name',
            'client_email',
            'client_phoneno',
            'address',
            'remarks',
            'vrn_no',
            'vin_no',
            'driver_name',
            'driver_license_no',
            'driver_contact_no',
            'purpose_visit',
            'entry_time',
            'entry_date',
            'exit_time',
            'exit_date',
            'duration_stay',
            'seal_no',
            'additional_notes',
            'entry_comment',
            'documents',
            'vendor_id',
            'driver_id'
        ];
        
        $obj=[];
		foreach ($data as $key => $value) {
			if(isset($request[$value]) && $request[$value]!=null && $request[$value]!=''){
				$obj[$value]=$request[$value];
                // $obj['order_id']=$orderid;
			}
		}

        if($request['id'] > 0){
            Log::info("Lookign for update Arrival");
            $arrived=PreArrivalDeparture::where('id', $request['id'])->where('order_type','arrival')
                // ->update($obj);
                ->first();

            $arrived->update($obj);

        } else {
            Log::info("Lookign for Create Arrival");
            $arrived = PreArrivalDeparture::create($obj);
        }
        
        return $arrived;
    }

}