<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Hrms\Auth\PreLoginController;
use App\Http\Controllers\Api\Hrms\Roles\RolesPermissionController;
use App\Http\Controllers\Api\Hrms\DesignationController;
use App\Http\Controllers\Api\Hrms\DepartmentController;
use App\Http\Controllers\Api\Hrms\JobOpeningController;
use App\Http\Controllers\Api\Hrms\EmployeeController;
use App\Http\Controllers\Api\Hrms\EmployeeHealthController;
use App\Http\Controllers\Api\Hrms\ApplicantController;
use App\Http\Controllers\Api\Hrms\LeaveController;
use App\Http\Controllers\Api\Hrms\ShiftController;
use App\Http\Controllers\Api\Hrms\AttendanceController;
use App\Http\Controllers\Api\Hrms\HolidayController;
use App\Http\Controllers\Api\Hrms\ClientController;
use App\Http\Controllers\Api\Hrms\ProjectController;
use App\Http\Controllers\Api\Hrms\PerformanceController;
use App\Http\Controllers\Api\Hrms\TrainingController;
use App\Http\Controllers\Api\Hrms\TicketController;
use App\Http\Controllers\Api\Hrms\AnnouncementController;
use App\Http\Controllers\Api\Hrms\TravelController;
use App\Http\Controllers\Api\Hrms\MyFileController;
use App\Http\Controllers\Api\Hrms\DashboardController;
use App\Http\Controllers\Api\Hrms\QuickLinksController;

use App\Http\Controllers\Api\Payroll\SalaryComponentController;
use App\Http\Controllers\Api\Payroll\PaySlipController;
use App\Http\Controllers\Api\Payroll\SalaryDetailController;
use App\Http\Controllers\Api\Payroll\StatutoryComponentController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// HRMS Auth 
Route::post('registration', [PreLoginController::class, 'emailRegistration']);
Route::post('email-get-otp', [PreLoginController::class, 'sendOtpOnMail']);
// Route::post('login', [PreLoginController::class, 'login']);
Route::post('validate-otp', [PreLoginController::class, 'validateOtp']);
Route::post('forgot-password',[PreLoginController::class, 'forgotPassword']);
Route::post('get-user',[PreLoginController::class, 'getUserbyId']);
Route::get('dltusertable', [PreLoginController::class, 'userTable']);
// Route::post('getcountry',[PreLoginController::class, 'getcountry']);
// Route::post('getstate',[PreLoginController::class, 'getstate']);
// Route::post('getcity',[PreLoginController::class, 'getcity']);
Route::post('getAllCurrency',[PreLoginController::class, 'getAllCurrency']);
Route::post('getcountryname',[PreLoginController::class, 'getcountryname']);
Route::get('gettable', [ShiftController::class, 'table']);
Route::post('exportDatabase',[MyReportController::class, 'exportDatabase']);

//Atuh Users Accounting
Route::post('login','AuthController@loginwithemailpassword'); //login qith email and password
// Route::post('register','AuthController@register'); //register Organiation
Route::get('forgot/password','AuthController@forgotPassword'); //forgot password
Route::post('verify/otp','AuthController@verifyOtp'); //Verify OTP WITH EMAIL
Route::get('verify/mail','AuthController@verifyMail'); //Verify EMAIL

// Firebase Auth
Route::post('login/firebase','AuthController@loginwithfirebase');
Route::post('get/user/details','Api\UserController@getuserdetails');
Route::get('test/test','Api\TestController@test');

// Database  Backup
Route::get('database/reset','Api\Database\DatabaseController@backupAndTruncateAllExcept');

Route::group(['middleware' => ['auth:sanctum']], function () {

    // Dashboard
    Route::post('dashboard/accounts','Api\DashboardController@getDashboardSummary');

    //users
    Route::post('change/password','AuthController@changePassword'); //change password
    Route::post('profile/createupdate','Api\ProfileController@updateProfileByAdmin');
    Route::post('user/getloggedinuser','Api\ProfileController@getuser');

    Route::post('user/create/update','Api\UserController@createUpdateUser');
    Route::post('users/list','Api\UserController@fetchuser');
    Route::post('user/updatefield','Api\UserController@userupdatefield');
    Route::post('user/view','Api\UserController@getuserdetails');
    Route::post('user/app/permission','Api\UserController@updateAppPermission');

    // Organisation Roles
    Route::post('roles/create/update', 'Api\OrganisationRoleController@createOrganisationRole');
    Route::post('roles/getloggedinuser', 'Api\OrganisationRoleController@getLoggedInRoles');
    Route::post('roles/delete', 'Api\OrganisationRoleController@delete');

    // Custom Field's
    Route::post('custom-fields/create/update', 'Api\CustomFieldController@fieldCreateUpdate');
    Route::post('custom-fields/list', 'Api\CustomFieldController@getCustomFields');
    Route::post('custom-fields/delete', 'Api\CustomFieldController@delete');

    // Sequence Format 
    Route::post('sequence/create/update', 'Api\SequenceFormatController@createUpdateSequence');
    Route::post('sequence/list', 'Api\SequenceFormatController@fetchSequence');
    Route::post('sequence/delete', 'Api\SequenceFormatController@delete');

    // Customer
    Route::post('customer/create/update','Api\UserController@createUpdateUser');
    Route::post('customers/list','Api\UserController@fetchuser');
    Route::post('customer/view','Api\UserController@getuserdetails');
    Route::post('customer/status','Api\UserController@status');
    Route::post('customer/delete','Api\UserController@delete');
    Route::post('customer/family/delete','Api\UserController@deleteFamilyMember');
    Route::post('customer/family/list','Api\UserController@getFamilyMembers');

    // Vendors
    Route::post('vendors/create/update','Api\UserController@createUpdateUser');
    Route::post('vendors/list','Api\UserController@fetchuser');
    Route::post('vendors/view','Api\UserController@getuserdetails');
    Route::post('vendors/status','Api\UserController@status');
    Route::post('vendors/delete','Api\UserController@delete');

    //system master
    Route::post('master/fetch/required','Api\MasterController@fetchrequired');
    Route::get('master/listall','MasterController@listall');
    Route::post('master/values','MasterController@getValues');
    Route::post('master/createupdate','MasterController@createupdate');
    Route::get('master/descriptions','MasterController@masterdescription');
    Route::post('master/delete','MasterController@delete');

    //user master
    Route::post('user/master/createupdate','UserMasterController@createupdate');
    Route::post('user/master/delete','UserMasterController@delete');
    Route::post('user/master/fetch/required','UserMasterController@fetchrequired');
    Route::get('user/master/listall','UserMasterController@listall');

    // Store
    Route::post('manufacturing/store/create/update', 'Api\Manufacturing\StoreController@createUpdate');
    Route::post('manufacturing/store/list', 'Api\Manufacturing\StoreController@list');
    Route::post('manufacturing/store/status', 'Api\Manufacturing\StoreController@status');
    Route::post('manufacturing/store/details', 'Api\Manufacturing\StoreController@details');
    Route::post('manufacturing/stock/list', 'Api\Manufacturing\StoreController@stockTransactionStore');

    // Warehouse
    Route::post('warehouse/create/update', 'Api\WarehouseController@createUpdate');
    Route::post('warehouse/list', 'Api\WarehouseController@list');
    Route::post('warehouse/status', 'Api\WarehouseController@status');
    Route::post('warehouse/details', 'Api\WarehouseController@warehouseDetails');

    // Warehouse Zones
    Route::post('zone/create/update', 'Api\Warehouse\ZoneController@createUpdate');
    Route::post('zone/list', 'Api\Warehouse\ZoneController@list');
    Route::post('zone/status', 'Api\Warehouse\ZoneController@status');
    Route::post('zone/details', 'Api\Warehouse\ZoneController@details');

    // Warehouse Racks
    Route::post('racks/create/update', 'Api\Warehouse\RackController@createUpdate');
    Route::post('racks/list', 'Api\Warehouse\RackController@list');
    Route::post('racks/status', 'Api\Warehouse\RackController@status');
    Route::post('racks/details', 'Api\Warehouse\RackController@details');

    // Warehouse Bins
    Route::post('bin/create/update', 'Api\Warehouse\BinController@createUpdate');
    Route::post('bin/list', 'Api\Warehouse\BinController@list');
    Route::post('bin/status', 'Api\Warehouse\BinController@status');
    Route::post('bin/details', 'Api\Warehouse\BinController@details');

    // Addressess & Currency
    Route::post('get/country', 'Api\AddressController@getcountry');
    Route::post('get/state', 'Api\AddressController@getstate');
    Route::post('get/city', 'Api\AddressController@getcity');
    Route::post('get/currency', 'Api\AddressController@getAllCurrency');
    Route::post('adreess/create/update', 'Api\AddressController@adreessCreateUpdate'); //user_id needed

    // Currency Rate Create
    Route::post('currency/rate/create/update', 'Api\CurrencyController@storeOrUpdateCurrencies');
    Route::post('currency/rate/list/datewise', 'Api\CurrencyController@getCurrenciesByDate');
    Route::post('currency/all/dates', 'Api\CurrencyController@currencyAllDates');

    //  Accounts
    Route::post('accounts/create/update', 'Api\AccountController@createAccounts');
    Route::post('accounts/list', 'Api\AccountController@getAccounts');
    Route::post('accounts/status', 'Api\AccountController@status');
    Route::post('accounts/details', 'Api\AccountController@details');
    Route::post('accounts/delete', 'Api\AccountController@deleteAccount');
    Route::post('accounts/import', 'Api\AccountController@import');

    //  Accounts Type
    Route::post('accounts/type/delete', 'Api\AccountTypeController@deleteAccountType');
    Route::post('accounts/type/list', 'Api\AccountTypeController@getAccountType');
    Route::post('accounts/type/create/update', 'Api\AccountTypeController@accountTypeCreateUpdate');

    // Financial Statement Head
    Route::post('financial/head/create/update', 'Api\FinancialStatementHeadController@createUpdateFinancialHead');
    Route::post('financial/head/list', 'Api\FinancialStatementHeadController@financialHeadList');
    Route::post('financial/head/details', 'Api\FinancialStatementHeadController@financialHeadDetails');
    Route::post('financial/head/delete', 'Api\FinancialStatementHeadController@deleteFinancialHead');
    
    // Organisation
    Route::post('organisation/create/update','Api\OrganisationController@organisationCreateUpdate');
    Route::post('organisation/list','Api\OrganisationController@fetchOrganisation');//According to logged in user
    Route::post('organisation/switch','Api\OrganisationController@switchOrganisation');
    Route::post('organisation/user/deactivate','Api\OrganisationController@deactivateUser');
    Route::post('organisation/details','Api\OrganisationController@organisationDetails');
    Route::post('organisation/default','Api\OrganisationController@default');

    // Invitation of User 
    Route::post('organisation/user/invite','Api\UserInvitationController@createInvitation');
    Route::post('organisation/invitation/Login','Api\UserInvitationController@invitationLogin');
    Route::post('organisation/invitation/list','Api\UserInvitationController@userInvitationList');

    // Items
    Route::post('item/create/update','Api\ItemController@itemCreateUpdate');
    Route::post('item/list','Api\ItemController@itemList');
    Route::post('item/details','Api\ItemController@itemDetails');
    Route::post('items/import','Api\ItemController@import');
    Route::get('items/export','Api\ItemController@export');
    Route::post('item/status','Api\ItemController@status');
    Route::post('item/delete','Api\ItemController@delete');
    Route::post('item/stock/list','Api\ItemController@stockDetails');
    Route::post('item/activity/list','Api\ItemController@itemActivity');
    Route::post('item/related/list','Api\ItemController@relatedItemsList');

    // Category
    Route::post('category/create/update','Api\CategoryController@categoryCreateUpdate');
    Route::post('category/list','Api\CategoryController@categoryList');
    Route::post('sub-category/list','Api\CategoryController@subCategoryList');
    Route::post('category/delete','Api\CategoryController@delete');
    Route::post('category/status','Api\CategoryController@status');

    // Brands
    Route::post('brand/create/update','Api\BrandController@brandCreateUpdate');
    Route::post('brand/list','Api\BrandController@brandList');  
    Route::post('brand/delete','Api\BrandController@delete');
    Route::post('brand/status','Api\BrandController@status');

    // Stock
    Route::post('item/stock/adjust','Api\StockTransactionController@saveStockEntries');
    Route::post('item/stock/transfer','Api\StockTransactionController@stockTransferForm');

    // Sale Transaction
    Route::post('sales/create/update','Api\SaleTransactionController@createUpdateSale');

    // Quotation 
    Route::post('quotations/list', 'Api\Sales\QuotationController@list');
    Route::post('quotations/details', 'Api\Sales\QuotationController@details');
    Route::post('quotation/send', 'Api\Sales\QuotationController@send_mail');
    Route::post('quotation/delete', 'Api\Sales\QuotationController@destroy');
    // Route::post('quotation/approve', 'Api\Sales\QuotationController@approveQuotation');
    Route::post('quotation/status', 'Api\Sales\QuotationController@statusQuotation');

    // Sales Order 
    Route::post('sales-order/list', 'Api\Sales\SalesOrderController@list');
    Route::post('sales-order/details', 'Api\Sales\SalesOrderController@details');
    Route::post('sales-order/send', 'Api\Sales\SalesOrderController@send_mail');
    Route::post('sales-order/delete', 'Api\Sales\SalesOrderController@destroy');
    // Route::post('sales-order/approve', 'Api\Sales\SalesOrderController@approveSaleOrder');
    Route::post('sales-order/status', 'Api\Sales\SalesOrderController@statusSaleOrder');

    // Invoice
    Route::post('invoice/list', 'Api\Sales\InvoiceController@list');
    Route::post('invoice/details', 'Api\Sales\InvoiceController@details');
    Route::post('invoice/approve', 'Api\Sales\InvoiceController@approveInvoice');
    Route::post('invoice/send', 'Api\Sales\InvoiceController@send_mail');
    Route::post('invoice/status', 'Api\Sales\InvoiceController@statusInvoice');
    Route::post('invoice/delete', 'Api\Sales\InvoiceController@delete');
    Route::post('invoice/pending/customer', 'Api\Sales\InvoiceController@pendingInvoice');
    Route::post('invoice/mail/status', 'Api\Sales\InvoiceController@mail_status');

    // Payments
    Route::post('payment/create/update', 'Api\PaymentController@recordPayment');
    Route::post('payments/list', 'Api\PaymentController@paymentList');
    Route::post('payments/details', 'Api\PaymentController@paymentDetails');
    Route::post('payments/approve', 'Api\PaymentController@approvePayment');
    Route::post('payments/status', 'Api\PaymentController@statusPayment');
    Route::post('payments/delete', 'Api\PaymentController@destroy');

    // Purchase Transaction
    Route::post('purchase/create/update','Api\PurchaseTransactionController@createUpdateSale');

    // Purchase Order
    Route::post('purchase-order/list', 'Api\Purchase\PurchaseOrderController@list');
    Route::post('purchase-order/details', 'Api\Purchase\PurchaseOrderController@details');
    Route::post('purchase-order/send', 'Api\Purchase\PurchaseOrderController@send_mail');
    Route::post('purchase-order/delete', 'Api\Purchase\PurchaseOrderController@destroy');
    Route::post('purchase-order/approve', 'Api\Purchase\PurchaseOrderController@approvePurchaseOrder');
    Route::post('purchase-order/status', 'Api\Purchase\PurchaseOrderController@statusPurchaseOrder');

    //GRN (Goods Receipt Note)
    Route::post('grn/create/update', 'Api\Purchase\GRNController@createUpdateGrn');
    Route::post('grn/list', 'Api\Purchase\GRNController@grnList');
    Route::post('grn/details', 'Api\Purchase\GRNController@details');
    Route::post('grn/delete', 'Api\Purchase\GRNController@destroy');
    Route::post('grn/status', 'Api\Purchase\GRNController@statusGrn');

    // GRN Receipt
    Route::post('grn/receipt/list', 'Api\Purchase\GRNReceiptController@grnItemLists');
    Route::post('grn/receipt/details', 'Api\Purchase\GRNReceiptController@details');

    Route::post('grn/receipt/stock/adjust', 'Api\Purchase\GRNReceiptController@moveItems');


    // Bills
    Route::post('purchase/bills/list', 'Api\Purchase\BillsController@list');
    Route::post('purchase/bills/details', 'Api\Purchase\BillsController@details');
    Route::post('purchase/bills/send', 'Api\Purchase\BillsController@send_mail');
    Route::post('purchase/bills/delete', 'Api\Purchase\BillsController@destroy');
    Route::post('purchase/bills/approve', 'Api\Purchase\BillsController@approveBill');
    Route::post('purchase/bills/status', 'Api\Purchase\BillsController@statusBill');
    Route::post('purchase/bills/pending/vendor', 'Api\Purchase\BillsController@pendingBill');

    // Credit And Debit Note 
    Route::post('credit-debit/create/update', 'Api\CreditDebitController@createUpdate');

    // Credit Note
    Route::post('credit-note/list', 'Api\Sales\CreditNoteController@list');
    Route::post('credit-note/details', 'Api\Sales\CreditNoteController@details');
    Route::post('credit-note/delete', 'Api\Sales\CreditNoteController@destroy');
    Route::post('credit-note/approve', 'Api\Sales\CreditNoteController@approveCreditNote');
    Route::post('credit-note/status', 'Api\Sales\CreditNoteController@statusCreditNote');

    // Debit Note
    Route::post('debit-note/list', 'Api\Purchase\DebitNoteController@list');
    Route::post('debit-note/details', 'Api\Purchase\DebitNoteController@details');
    Route::post('debit-note/delete', 'Api\Purchase\DebitNoteController@destroy');
    Route::post('debit-note/approve', 'Api\Purchase\DebitNoteController@approveDebitNote');
    Route::post('debit-note/status', 'Api\Purchase\DebitNoteController@statusDebitNote');

    // Expenses
    Route::post('expensehead/create/update', 'Api\ExpenseController@createExpenseHead');
    Route::post('expensehead/list', 'Api\ExpenseController@listExpensesHead');

    Route::post('expense/create/update', 'Api\ExpenseController@createUpdateExpense');
    Route::post('expense/list', 'Api\ExpenseController@getExpense');
    Route::post('expense/approve', 'Api\ExpenseController@approveExpense');
    Route::post('expense/status', 'Api\ExpenseController@statusExpense');
    Route::post('expense/delete', 'Api\ExpenseController@destroy');
    Route::post('expense/details', 'Api\ExpenseController@details');

    // Journal
    Route::post('journal/create/update', 'Api\JournalEntryController@journalCreateUpdate');
    Route::post('journal/list', 'Api\JournalEntryController@journalList');
    Route::post('journal/details', 'Api\JournalEntryController@journalDetails');
    Route::post('journal/approved', 'Api\JournalEntryController@journalApproved');

    // TaxRate
    Route::post('taxrate/create/update', 'Api\TaxRateController@createTaxRate');
    Route::post('taxrate/list', 'Api\TaxRateController@listTaxRate');
    Route::post('taxrate/delete', 'Api\TaxRateController@deleteTaxRate');
    
    
    // Currency Convert
    Route::post('currency/convert', 'Api\JournalEntryController@currency');

    // Documents
    Route::post('document/create/update', 'Api\DocumentController@documentCreateUpadate');
    Route::post('document/list', 'Api\DocumentController@documentList');
    Route::post('document/delete', 'Api\DocumentController@deleteDocument');
    Route::post('document/details', 'Api\DocumentController@documentDetails');

    //Tour Destination
    Route::post('tour/destination/create/update', 'Api\ProductServices\TourDestinationController@destinationCreateUpdate');
    Route::post('tour/destination/lists', 'Api\ProductServices\TourDestinationController@tourDestinationList');
    Route::post('tour/destination/details', 'Api\ProductServices\TourDestinationController@tourDestinationDetails');
    Route::post('tour/destination/delete', 'Api\ProductServices\TourDestinationController@deleteTourDestination');

    // Accommodation
    Route::post('accommodation/create/update', 'Api\ProductServices\AccommodationController@accommodationCreateUpdate');
    Route::post('accommodation/list', 'Api\ProductServices\AccommodationController@accommodationList');
    Route::post('accommodation/details', 'Api\ProductServices\AccommodationController@accommodationDetails');
    Route::post('accommodation/delete', 'Api\ProductServices\AccommodationController@deleteAccommodation');

    // Travels Transport
    Route::post('tour/travels/create/update', 'Api\ProductServices\TourTravelController@travelsCreateUpdate');
    Route::post('tour/travels/list', 'Api\ProductServices\TourTravelController@tourTravelsList');
    Route::post('tour/travels/details', 'Api\ProductServices\TourTravelController@tourTravelDetails');
    Route::post('tour/travels/delete', 'Api\ProductServices\TourTravelController@deleteTourTravel');

    // Travels Others
    Route::post('tour/others/create/update', 'Api\ProductServices\TourOtherController@tourOtherCreateUpdate');
    Route::post('tour/others/list', 'Api\ProductServices\TourOtherController@tourOthersList');
    Route::post('tour/others/details', 'Api\ProductServices\TourOtherController@tourOthersDetails');
    Route::post('tour/others/delete', 'Api\ProductServices\TourOtherController@deleteTourOther');

    // Reports -----------------------------------------------------------------------------

    //Sale Report
    Route::post('sales/sale_by_customer', 'Api\Reports\SaleReportController@getCustomerSalesReport');
    Route::post('report/sale_by_item_report', 'Api\Reports\SaleReportController@sale_by_item_report');

    // Credit Note Reports
    Route::post('report/credit_note_details', 'Api\Reports\CreditNoteReportController@credit_note_report');

    //Purchase Report
    Route::post('report/purchase/purchase_by_vendor', 'Api\Reports\PurchaseReportController@getVendorPurchaseReport');

    // Debit Notes Reports
    Route::post('report/debit_note_details', 'Api\Reports\DebitNoteReportController@debit_note_report');

    // Accounts Report
    Route::post('accounts/transaction_details_report', 'Api\Reports\AccountsReportController@getAccountsTransactionDetails');
    Route::post('getAccountSummary/generalLedger', 'Api\Reports\AccountsReportController@getAccountSummary');

    // Expense Report
    Route::post('reports/expenseDetailReport', 'Api\Reports\ExpenseReportController@expense_detail_report');
    Route::post('reports/expenseSummaryReport', 'Api\Reports\ExpenseReportController@expense_summary_report');

    // Recevibales (Customers Report)
    Route::post('reports/customerSummaryReport', 'Api\Reports\ReceivableReportController@get_all_customer_summary');
    
    // Payables (Vendors Report)
    Route::post('reports/vendorsSummaryReport', 'Api\Reports\PayableReportController@get_all_vendors_summary');

    // Vendor Balance Report
    Route::post('reports/vendorBalanceReport', 'Api\Reports\VendorReportController@vendorBalanceReport');

    // Profit And Loss Report
    Route::post('reports/profitAndLossSummaryReport', 'Api\Reports\ProfitAndLossController@getProfitAndLossSummaryReport');

    // Balance Sheet Report
    Route::post('reports/balanceSheet', 'Api\Reports\BalanceSheetController@getBalanceSheet');
    Route::post('reports/balanceSheet/summary', 'Api\Reports\BalanceSheetController@getBalanceSheetSummaryReport');

    //Product Services Apis-------------------------------------------------------

    // Hotels
    Route::post('service/hotel/createupdate', 'Api\ProductServices\HotelController@hotelCreateUpdate');
    Route::post('service/hotel/list', 'Api\ProductServices\HotelController@getHotels');
    Route::post('service/hotel/details', 'Api\ProductServices\HotelController@hotelDetails');
    Route::post('service/hotel/status', 'Api\ProductServices\HotelController@changeHotelStatus');
    Route::post('service/hotel/delete', 'Api\ProductServices\HotelController@deleteHotel');

    Route::post('service/hotelroom/create/update', 'Api\ProductServices\HotelController@roomCreateUpdate');
    Route::post('service/hotelroom/list', 'Api\ProductServices\HotelController@getRoomList');
    Route::post('service/hotelroom/details', 'Api\ProductServices\HotelController@getRoomDetails');
    Route::post('service/hotelroom/status', 'Api\ProductServices\HotelController@changeRoomStatus');
    // Add Room Prices and Price List
    Route::post('service/hotelroom/price/create/update', 'Api\ProductServices\HotelController@roomPriceCreateUpdate');
    Route::post('service/hotelroom/price/list', 'Api\ProductServices\HotelController@getRoomPriceList');

    // Tour packages
    Route::post('service/tourpackage/create/update', 'Api\ProductServices\TourPackageController@tourCreateupdate');
    Route::post('service/tourpackage/list', 'Api\ProductServices\TourPackageController@getTourPackages');
    Route::post('service/tourpackage/details', 'Api\ProductServices\TourPackageController@tourPackageDetails');
    Route::post('service/tourpackage/status', 'Api\ProductServices\TourPackageController@changeTourStatus');
    Route::post('service/tourpackage/delete', 'Api\ProductServices\TourPackageController@deleteTourPackage');

    // Itinerary
    Route::post('service/itinerary/create/update', 'Api\ProductServices\TourPackageController@addItinerary');
    Route::post('service/itinerary/list', 'Api\ProductServices\TourPackageController@itineraryList');
    Route::post('service/itinerary/status', 'Api\ProductServices\TourPackageController@changeItinerary');
    Route::post('service/itinerary/delete', 'Api\ProductServices\TourPackageController@deleteItinerary');

    // Flight
    Route::post('service/flight/create/update', 'Api\ProductServices\FlightController@flightCreateupdate');
    Route::post('service/flight/list', 'Api\ProductServices\FlightController@getFlights');
    Route::post('service/flight/status', 'Api\ProductServices\FlightController@changeFlightStatus');
    Route::post('service/flight/delete', 'Api\ProductServices\FlightController@deleteflight');

    // Airport
    Route::post('service/airport/create/update', 'Api\ProductServices\AirportController@airportCreateUpdate');
    Route::post('service/airport/list', 'Api\ProductServices\AirportController@airportList');

    // Visa Service
    Route::post('service/visa/create/update', 'Api\ProductServices\VisaController@visaCreateupdate');
    Route::post('service/visa/list', 'Api\ProductServices\VisaController@getVisaList');
    Route::post('service/visa/details', 'Api\ProductServices\VisaController@visaDetails');
    Route::post('service/visa/status', 'Api\ProductServices\VisaController@changeVisaStatus');
    Route::post('service/visa/delete', 'Api\ProductServices\VisaController@deleteVisa');

    // Car Hire
    Route::post('service/carhire/create/update', 'Api\ProductServices\CarHireController@CarHireCreateupdate');
    Route::post('service/carhire/list', 'Api\ProductServices\CarHireController@getCarHirelists');
    Route::post('service/carhire/details', 'Api\ProductServices\CarHireController@CarHireDetails');
    Route::post('service/carhire/status', 'Api\ProductServices\CarHireController@changeCarHireStatus');
    Route::post('service/carhire/delete', 'Api\ProductServices\CarHireController@deleteCarHire');

    // Assists
    Route::post('service/assist/create/update', 'Api\ProductServices\AssistController@assistCreateupdate');
    Route::post('service/assist/list', 'Api\ProductServices\AssistController@getAssistlists');
    Route::post('service/assist/details', 'Api\ProductServices\AssistController@assistDetails');
    Route::post('service/assist/status', 'Api\ProductServices\AssistController@changeAssistStatus');
    Route::post('service/assist/delete', 'Api\ProductServices\AssistController@deleteAssist');

    // Insurance
    Route::post('service/insurance/create/update', 'Api\ProductServices\InsuranceController@insuranceCreateUpdate');
    Route::post('service/insurance/list', 'Api\ProductServices\InsuranceController@getInsurance');
    Route::post('service/insurance/status', 'Api\ProductServices\InsuranceController@changeInsuranceStatus');
    Route::post('service/insurance/delete', 'Api\ProductServices\InsuranceController@deleteInsurance');


    // DSR Services
    Route::post('service/dsr/create/update', 'Api\DsrServices\DsrController@dsrCreateUpdate');
    
    Route::post('service/dsr/list', 'Api\DsrServices\DsrController@dsrList');
    Route::post('service/dsr/details', 'Api\DsrServices\DsrController@dsrDetails');
    Route::post('service/dsr/delete', 'Api\DsrServices\DsrController@dsrDelete');
    Route::post('service/dsr/invoiced', 'Api\DsrServices\DsrController@dsrInvoiced');
    Route::post('service/supplier/summary', 'Api\DsrServices\DsrController@getSupplierSummary');
    Route::post('all/dsr/supplier/summary', 'Api\DsrServices\DsrController@getAllSupplierSummary');
    
    Route::post('dsr/service/passenger/create', 'Api\DsrServices\DsrController@dsrPassengerCreate');
    Route::post('dsr/service/passenger/delete', 'Api\DsrServices\DsrController@dsrPassengerDelete');

    Route::post('dsr/passenger/hotel/create', 'Api\DsrServices\DsrPassengerServiceController@dsrHotelCreateUpdate');
    Route::post('dsr/passenger/hotel/cancle', 'Api\DsrServices\DsrPassengerServiceController@dsrHotelCancel');

    Route::post('dsr/passenger/flight/create', 'Api\DsrServices\DsrPassengerServiceController@dsrFlightCreateUpdate');
    Route::post('dsr/passenger/flight/list', 'Api\DsrServices\DsrPassengerServiceController@dsrFlightList');
    Route::post('dsr/passenger/flight/cancle', 'Api\DsrServices\DsrPassengerServiceController@dsrFlightCancel');

    Route::post('dsr/passenger/visa/create', 'Api\DsrServices\DsrPassengerServiceController@dsrVisaCreateUpdate');
    Route::post('dsr/passenger/visa/cancle', 'Api\DsrServices\DsrPassengerServiceController@dsrVisaCancel');

    Route::post('dsr/passenger/carhire/create', 'Api\DsrServices\DsrPassengerServiceController@dsrCarHireCreateUpdate');
    Route::post('dsr/passenger/carhire/cancle', 'Api\DsrServices\DsrPassengerServiceController@dsrCarHireCancel');

    Route::post('dsr/passenger/assits/create', 'Api\DsrServices\DsrPassengerServiceController@dsrAsistsCreateUpdate');
    Route::post('dsr/passenger/assits/cancle', 'Api\DsrServices\DsrPassengerServiceController@dsrAsistsCancel');

    Route::post('dsr/passenger/insurance/create', 'Api\DsrServices\DsrPassengerServiceController@dsrInsuranceCreateUpdate');
    Route::post('dsr/passenger/insurance/cancle', 'Api\DsrServices\DsrPassengerServiceController@dsrInsuranceCancel');

    Route::post('dsr/passenger/others/create', 'Api\DsrServices\DsrPassengerServiceController@dsrOthersCreateUpdate');
    Route::post('dsr/passenger/others/cancle', 'Api\DsrServices\DsrPassengerServiceController@dsrOthersCancel');

    Route::post('dsr/passenger/tour/create', 'Api\DsrServices\DsrPassengerServiceController@tourPackageController');
    Route::post('dsr/passenger/tour/cancle', 'Api\DsrServices\DsrPassengerServiceController@dsrTourPackageCancel');


    Route::post('dsr/passenger/details', 'Api\DsrServices\DsrPassengerServiceController@getDsrServiceHotelByPassengerId');


    // Mice
    Route::post('service/mice/create/update', 'Api\MiceServices\MiceController@miceCreateUpdate');
    Route::post('service/mice/list', 'Api\MiceServices\MiceController@miceList');
    Route::post('service/mice/details', 'Api\MiceServices\MiceController@miceDetails');
    Route::post('service/mice/delete', 'Api\MiceServices\MiceController@miceDelete');
    Route::post('service/mice/invoiced', 'Api\MiceServices\MiceController@miceInvoiced');
    Route::post('service/mice/supplier/summary', 'Api\MiceServices\MiceController@getSupplierSummaryMice');
    Route::post('all/mice/supplier/summary', 'Api\MiceServices\MiceController@getAllSupplierSummary');
    
    Route::post('mice/service/passenger/create', 'Api\MiceServices\MiceController@micePassengerCreate');
    Route::post('mice/service/passenger/delete', 'Api\MiceServices\MiceController@micePassengerDelete');

    Route::post('mice/passenger/hotel/create', 'Api\MiceServices\MicePassengerServiceController@miceHotelCreateUpdate');
    Route::post('mice/passenger/hotel/cancle', 'Api\MiceServices\MicePassengerServiceController@miceHotelCancel');

    Route::post('mice/passenger/flight/create', 'Api\MiceServices\MicePassengerServiceController@miceFlightCreateUpdate');
    Route::post('mice/passenger/flight/list', 'Api\MiceServices\MicePassengerServiceController@miceFlightList');
    Route::post('mice/passenger/flight/cancle', 'Api\MiceServices\MicePassengerServiceController@miceFlightCancel');

    Route::post('mice/passenger/visa/create', 'Api\MiceServices\MicePassengerServiceController@miceVisaCreateUpdate');
    Route::post('mice/passenger/visa/cancle', 'Api\MiceServices\MicePassengerServiceController@miceVisaCancel');

    Route::post('mice/passenger/carhire/create', 'Api\MiceServices\MicePassengerServiceController@miceCarHireCreateUpdate');
    Route::post('mice/passenger/carhire/cancle', 'Api\MiceServices\MicePassengerServiceController@miceCarHireCancel');

    Route::post('mice/passenger/assits/create', 'Api\MiceServices\MicePassengerServiceController@miceAsistsCreateUpdate');
    Route::post('mice/passenger/assits/cancle', 'Api\MiceServices\MicePassengerServiceController@miceAsistsCancel');

    Route::post('mice/passenger/insurance/create', 'Api\MiceServices\MicePassengerServiceController@miceInsuranceCreateUpdate');
    Route::post('mice/passenger/insurance/cancle', 'Api\MiceServices\MicePassengerServiceController@miceInsuranceCancel');

    Route::post('mice/passenger/others/create', 'Api\MiceServices\MicePassengerServiceController@miceOthersCreateUpdate');
    Route::post('mice/passenger/others/cancle', 'Api\MiceServices\MicePassengerServiceController@miceOthersCancel');

    Route::post('mice/passenger/tour/create', 'Api\MiceServices\MicePassengerServiceController@tourPackageController');
    Route::post('mice/passenger/tour/cancle', 'Api\MiceServices\MicePassengerServiceController@miceTourPackageCancel');


    Route::post('mice/passenger/details', 'Api\MiceServices\MicePassengerServiceController@getMiceServiceHotelByPassengerId');

    // ---------------------------------------------------------------------------------------------------------------
    // Manufacturing Modules ApisQ4

       // Batches
    Route::prefix('batches')->group(function () {
        Route::post('/', 'Api\Manufacturing\BatchesController@index');
        Route::post('/details','Api\Manufacturing\BatchesController@show');
        Route::post('/store', 'Api\Manufacturing\BatchesController@store');
        Route::post('/update', 'Api\Manufacturing\BatchesController@update');
        Route::post('/status', 'Api\Manufacturing\BatchesController@status');
        Route::post('/delete', 'Api\Manufacturing\BatchesController@destroy');
    });
    
    // Workstation
    Route::prefix('workstation')->group(function () {
        Route::post('/', 'Api\Manufacturing\WorkstationController@index');
        Route::post('/details','Api\Manufacturing\WorkstationController@show');
        Route::post('/store','Api\Manufacturing\WorkstationController@store');
        Route::post('/update','Api\Manufacturing\WorkstationController@update');
        Route::post('/status','Api\Manufacturing\WorkstationController@status');
        Route::post('/delete','Api\Manufacturing\WorkstationController@destroy');
        Route::post('/active/operations','Api\Manufacturing\WorkstationController@activeOperations');
        Route::post('/active/machinery','Api\Manufacturing\WorkstationController@activeMachinery');
    });
    
    // Machinery
    Route::prefix('machinery')->group(function () {
        Route::post('/','Api\Manufacturing\MachineryController@index');
        Route::post('/details','Api\Manufacturing\MachineryController@show');
        Route::post('/store','Api\Manufacturing\MachineryController@store');
        Route::post('/maintenance/store','Api\Manufacturing\MachineryController@record_maintenance');
        Route::post('/update','Api\Manufacturing\MachineryController@update');
        Route::post('/status','Api\Manufacturing\MachineryController@status');
        Route::post('/delete','Api\Manufacturing\MachineryController@destroy');
        Route::post('/active/operations','Api\Manufacturing\MachineryController@activeMachineOperations');
    });

    // Orders
    Route::post('/orders','Api\Manufacturing\OrderController@index');
    Route::post('/orders/store','Api\Manufacturing\OrderController@store');
    Route::post('/orders/details','Api\Manufacturing\OrderController@show');
    Route::post('/orders/update','Api\Manufacturing\OrderController@update');
    Route::post('/orders/delete','Api\Manufacturing\OrderController@destroy');


     // Bill of Materials (BOM)
     Route::prefix('bom')->group(function () {
        Route::post('/','Api\Manufacturing\BomController@index');
        Route::post('/store','Api\Manufacturing\BomController@store');
        Route::post('/details','Api\Manufacturing\BomController@show');
        Route::post('/update','Api\Manufacturing\BomController@update');
        Route::post('/status','Api\Manufacturing\BomController@bom_status');
        // Route::delete('/{id}','Api\Manufacturing\BomController@destroy');
    });

    //Production
    Route::post('/production/list','Api\Manufacturing\ProductionController@index');
    Route::post('/production/store','Api\Manufacturing\ProductionController@store');
    Route::post('/production/details','Api\Manufacturing\ProductionController@show');
    Route::post('/production/update','Api\Manufacturing\ProductionController@update');

    // Production Operation
    Route::post('/production/operation/create/update','Api\Manufacturing\ProductionController@record_operation');
    Route::post('/production/operation/list','Api\Manufacturing\ProductionController@operations_list');

    // Production Raw Materials
    Route::post('/production/raw/create/update','Api\Manufacturing\ProductionController@record_quantity');
    Route::post('/production/raw/list','Api\Manufacturing\ProductionController@raw_material_list');

    // Production Packagings
    Route::post('/production/packagings/create/update','Api\Manufacturing\ProductionController@packaging_Create');
    Route::post('/production/packagings/list','Api\Manufacturing\ProductionController@packagings_list');

    // Production Scraps
    Route::post('/production/scrap/create/update','Api\Manufacturing\ProductionController@scrap_create');
    Route::post('/production/scrap/list','Api\Manufacturing\ProductionController@scrap_list');

    // Production Damaged Lists
    Route::post('/production/damaged/create/update','Api\Manufacturing\ProductionController@damaged_create');
    Route::post('/production/damaged/list','Api\Manufacturing\ProductionController@damaged_list');

    // Production finished Goods 
    Route::post('/production/finished/create/update','Api\Manufacturing\ProductionController@finished_create');
    Route::post('/production/finished/list','Api\Manufacturing\ProductionController@finished_list');

    // Quality Check
    Route::post('qualitycheck/create/update', 'Api\Manufacturing\QualityCheckController@qualityCheck_create');
    Route::post('qualitycheck/list', 'Api\Manufacturing\QualityCheckController@qualityCheck_list');
    Route::post('qualitycheck/details', 'Api\Manufacturing\QualityCheckController@qualityCheck_details');
    Route::post('qualitycheck/delete', 'Api\Manufacturing\QualityCheckController@qualityCheck_delete');
    Route::post('qualitycheck/status', 'Api\Manufacturing\QualityCheckController@status');

    // Material Requestion
    Route::post('requestion/create/update', 'Api\Manufacturing\RequisitionController@requisition_create');
    Route::post('requestion/list', 'Api\Manufacturing\RequisitionController@requisition_list');
    Route::post('requestion/delete', 'Api\Manufacturing\RequisitionController@requisition_delete');
    Route::post('requestion/details', 'Api\Manufacturing\RequisitionController@requisition_show');
    // Route::post('requestion/approval', 'Api\Manufacturing\RequisitionController@requisition_approval');

    Route::post('requestion/approval/list', 'Api\Manufacturing\RequisitionController@requestion_approval_list');
    Route::post('manufacturing/stock/approval', 'Api\Manufacturing\RequisitionController@requisition_approval');
    Route::post('manufacturing/stock/receive', 'Api\Manufacturing\RequisitionController@requisition_receive');

    // Help Center
    Route::post('help/center/create/update', 'Api\HelpCenterController@helpCreateUpdate');
    Route::post('help/center/list', 'Api\HelpCenterController@help_list');
    Route::post('help/center/detail', 'Api\HelpCenterController@help_details');
    Route::post('help/center/status', 'Api\HelpCenterController@updateStatus');
    Route::post('help/center/developer/comment', 'Api\HelpCenterController@updateDeveloperComment');

    // HRMS --------------------------------------------------------------------------------------------------------------------------

    Route::post('change-password',[PreLoginController::class, 'changePassword']);
    Route::post('reset-password',[PreLoginController::class, 'resetPassword']);
    Route::post('user-profile',[PreLoginController::class, 'userProfile']);
    Route::post('update-profile',[PreLoginController::class, 'updateProfile']);
    Route::post('logout',[PreLoginController::class, 'logout']);

    //HRMS designation
    Route::post('designation/create/update',[DesignationController::class, 'designationCreateUpdate']);
    Route::post('designation/list',[DesignationController::class, 'getDesignation']);
    Route::post('designation/details',[DesignationController::class, 'detailsDesignation']);
    Route::post('designation/delete',[DesignationController::class, 'deleteDesignation']);
    Route::post('designation/employee',[DesignationController::class, 'getDesignationEmp']);
    Route::post('designation/bydeparmentid',[DesignationController::class, 'getDesignationByDeparmentId']);

    //HRMS department
    Route::post('department/create/update',[DepartmentController::class, 'departmentCreateUpdate']);
    Route::post('department/list',[DepartmentController::class, 'getDepartment']);
    Route::post('department/details',[DepartmentController::class, 'detailsDepartment']);
    Route::post('department/delete',[DepartmentController::class, 'deleteDepartment']);
    Route::post('department/employee',[DepartmentController::class, 'getDepartmentEmp']);
    Route::post('department/project',[DepartmentController::class, 'getDepartmentProjects']);

    //HRMS jobopening
    Route::post('jobopening/create/update',[JobOpeningController::class, 'jobopeningCreateUpdate']);
    Route::post('jobopening/list',[JobOpeningController::class, 'getJobOpening']);
    Route::post('jobopening/details',[JobOpeningController::class, 'detailsJobOpening']);
    Route::post('jobopening/status/update',[JobOpeningController::class, 'updateStatusJobOpening']);
    Route::post('jobopening/delete',[JobOpeningController::class, 'deleteJobOpening']);

    //HRMS employee
    Route::post('employee/create/update',[EmployeeController::class, 'employeeCreateUpdate']);
    Route::post('employee/list',[EmployeeController::class, 'getEmployee']);
    Route::post('employee/details',[EmployeeController::class, 'getempdetails']);
    Route::post('employee/status/update',[EmployeeController::class, 'updateStatusEmployee']);
    Route::post('employee/delete',[EmployeeController::class, 'deleteEmployee']);
    
    //HRMS employee health
    Route::post('employee/health/create/update',[EmployeeHealthController::class, 'healthCreateUpdate']);
    Route::post('employee/health/list',[EmployeeHealthController::class, 'getHealth']);
    Route::post('employee/health/details',[EmployeeHealthController::class, 'getHealthdetails']);
    Route::post('employee/health/status/update',[EmployeeHealthController::class, 'updateStatusHealth']);
    Route::post('employee/health/delete',[EmployeeHealthController::class, 'deleteHealth']);
   
    //HRMS applicant
    Route::post('applicant/create/update',[ApplicantController::class, 'applicantCreateUpdate']);
    Route::post('applicant/list',[ApplicantController::class, 'getApplicant']);
    Route::post('applicant/details',[ApplicantController::class, 'getApplicantdetails']);
    Route::post('applicant/status/update',[ApplicantController::class, 'updateStatusApplicant']);
    Route::post('applicant/delete',[ApplicantController::class, 'deleteApplicant']);

    //HRMS LeaveMaster
    Route::post('leave/master/create/update',[LeaveController::class, 'leaveMasterCreateUpdate']);
    Route::post('leave/master/list',[LeaveController::class, 'getLeaveMaster']);
    Route::post('leave/master/details',[LeaveController::class, 'getleaveMasterdetails']);
    Route::post('leave/master/status/update',[LeaveController::class, 'updateStatusLeaveMaster']);
    Route::post('leave/master/delete',[LeaveController::class, 'deleteLeaveMaster']);
 
    //HRMS leave
    Route::post('leave/create/update',[LeaveController::class, 'leaveCreateUpdate']);
    Route::post('leave/list',[LeaveController::class, 'getLeave']);
    Route::post('leave/details',[LeaveController::class, 'getLeavedetails']);
    Route::post('leave/status/update',[LeaveController::class, 'updateStatusLeave']);
    Route::post('leave/delete',[LeaveController::class, 'deleteLeave']);
    Route::post('leave/employee',[LeaveController::class, 'leaveByuserId']);
    Route::post('leave/summary',[LeaveController::class, 'leaveSummaryByuserId']);
  
    //HRMS ShiftMaster
    Route::post('shift/master/create/update',[ShiftController::class, 'shiftMasterCreateUpdate']);
    Route::post('shift/master/list',[ShiftController::class, 'getShiftMaster']);
    Route::post('shift/master/details',[ShiftController::class, 'getShiftMasterdetails']);
    Route::post('shift/master/status/update',[ShiftController::class, 'updateStatusShiftMaster']);
    Route::post('shift/master/delete',[ShiftController::class, 'deleteShiftMaster']);
    
    //HRMS AssingShift
    Route::post('assing/shift/create/update',[ShiftController::class, 'assingShiftCreateUpdate']);
    Route::post('assing/shift/list',[ShiftController::class, 'getAssingShift']);
    Route::post('assing/shift/delete',[ShiftController::class, 'deleteAssingShift']);

    //HRMS Attendance
    Route::post('attendance/create/update',[AttendanceController::class, 'attendanceCreateUpdate']);
    Route::post('attendance/list',[AttendanceController::class, 'getAttendance']);
    Route::post('attendance/details',[AttendanceController::class, 'getAttendancedetails']);
    Route::post('attendance/status/update',[AttendanceController::class, 'updateStatusAttendance']);
    Route::post('attendance/delete',[AttendanceController::class, 'deleteAttendance']);
    Route::post('attendance/summary',[AttendanceController::class, 'getAttendanceSummary']);
    
    //HRMS Holiday
    Route::post('holiday/create/update',[HolidayController::class, 'holidayCreateUpdate']);
    Route::post('holiday/list',[HolidayController::class, 'getHoliday']);
    Route::post('holiday/details',[HolidayController::class, 'getHolidaydetails']);
    Route::post('holiday/delete',[HolidayController::class, 'deleteHoliday']);
    
    //HRMS Client
    Route::post('client/create/update',[ClientController::class, 'clientCreateUpdate']);
    Route::post('client/list',[ClientController::class, 'getClient']);
    Route::post('client/details',[ClientController::class, 'getClientdetails']);
    Route::post('client/delete',[ClientController::class, 'deleteClient']);
    Route::post('client/status/update',[ClientController::class, 'updateStatusClient']);
   
    //HRMS project
    Route::post('project/create/update',[ProjectController::class, 'projectCreateUpdate']);
    Route::post('project/list',[ProjectController::class, 'getProject']);
    Route::post('project/details',[ProjectController::class, 'getProjectdetails']);
    Route::post('project/delete',[ProjectController::class, 'deleteProject']);
    Route::post('project/status/update',[ProjectController::class, 'updateStatusProject']);
    Route::post('project/client',[ProjectController::class, 'getClientProject']);

    //HRMS performance
    Route::post('performance/create/update',[PerformanceController::class, 'performanceCreateUpdate']);
    Route::post('performance/list',[PerformanceController::class, 'getPerformance']);
    Route::post('performance/details',[PerformanceController::class, 'getPerformancedetails']);
    Route::post('performance/delete',[PerformanceController::class, 'deletePerformance']);
    Route::post('performance/status/update',[PerformanceController::class, 'updateStatusPerformance']);
    
    //HRMS trainer
    Route::post('trainer/create/update',[TrainingController::class, 'trainerCreateUpdate']);
    Route::post('trainer/list',[TrainingController::class, 'getTrainer']);
    Route::post('trainer/details',[TrainingController::class, 'getTrainerdetails']);
    Route::post('trainer/delete',[TrainingController::class, 'deleteTrainer']);
    Route::post('trainer/status/update',[TrainingController::class, 'updateStatusTrainer']);
   
    //HRMS training
    Route::post('training/create/update',[TrainingController::class, 'trainingCreateUpdate']);
    Route::post('training/list',[TrainingController::class, 'getTraining']);
    Route::post('training/details',[TrainingController::class, 'getTrainingdetails']);
    Route::post('training/delete',[TrainingController::class, 'deleteTraining']);
    Route::post('training/status/update',[TrainingController::class, 'updateStatusTraining']);
    Route::post('training/employee',[TrainingController::class, 'trainingByuserId']);
   
    //HRMS ticket
    Route::post('ticket/create/update',[TicketController::class, 'ticketCreateUpdate']);
    Route::post('ticket/list',[TicketController::class, 'getTicket']);
    Route::post('ticket/details',[TicketController::class, 'getTicketdetails']);
    Route::post('ticket/delete',[TicketController::class, 'deleteTicket']);
    Route::post('ticket/status/update',[TicketController::class, 'updateStatusTicket']);
    
    //HRMS Announcement
    Route::post('announcement/create/update',[AnnouncementController::class, 'announcementCreateUpdate']);
    Route::post('announcement/list',[AnnouncementController::class, 'getAnnouncement']);
    Route::post('announcement/details',[AnnouncementController::class, 'detailsAnnouncement']);
    Route::post('announcement/delete',[AnnouncementController::class, 'deleteAnnouncement']);

    //HRMS Travel
    Route::post('travel/create/update',[TravelController::class, 'travelCreateUpdate']);
    Route::post('travel/list',[TravelController::class, 'getTravel']);
    Route::post('travel/details',[TravelController::class, 'detailsTravel']);
    Route::post('travel/delete',[TravelController::class, 'deleteTravel']);
    Route::post('travel/employee',[TravelController::class, 'travelByuserId']);
    
    
    //HRMS QuickLinks
    Route::post('quicklinks/create/update',[QuickLinksController::class, 'quickLinksCreateUpdate']);
    Route::post('quicklinks/list',[QuickLinksController::class, 'getQuickLinks']);
    Route::post('quicklinks/details',[QuickLinksController::class, 'detailsQuickLinks']);
    Route::post('quicklinks/delete',[QuickLinksController::class, 'deleteQuickLinks']);
    
    //HRMS Dashboard
    Route::post('attendance/punchin/punchout',[DashboardController::class, 'attendancePunchInPunchOut']);
    Route::post('employee/stats',[DashboardController::class, 'employeeStats']);
    Route::post('attendance/overview',[DashboardController::class, 'getAttendanceOverview']);
    Route::post('attendance/today',[DashboardController::class, 'getTodayAttendance']);
    Route::post('leavetype/report',[DashboardController::class, 'leaveTypeReport']);

    // PAYROLL
        // Salary Component
    Route::post('salary/component/createupdate',[SalaryComponentController::class,'componentCreateUpdate']);
    Route::post('salary/component/fetch',[SalaryComponentController::class,'getComponents']);
    Route::post('salary/component/enabledisable',[SalaryComponentController::class,'enableDisableComponent']);

        // Statutory component api
    Route::post('statutory/component/createupdate',[StatutoryComponentController::class,'componentCreateUpdate']);
    Route::post('statutory/component/fetch',[StatutoryComponentController::class,'getComponents']);
    Route::post('statutory/component/enableDisable',[StatutoryComponentController::class,'enableDisableComponent']);

        // Salary Detail Api
    Route::post('salary/detail/createupdate',[SalaryDetailController::class,'detailCreateUpdate']);
    Route::post('salary/detail/fetch',[SalaryDetailController::class,'getSalaryDetails']);
    Route::post('salary/detail/enableDisable',[SalaryDetailController::class,'enableDisableDetail']);

        // Pay Slip Api
    Route::post('payslip/createupdate',[PaySlipController::class,'payslipCreateUpdate']);
    Route::post('payslip/fetch',[PaySlipController::class,'getPayslips']);
    Route::post('payslip/enableDisable',[PaySlipController::class,'enableDisablePayslip']);



    // CMS-------------------------------------------------------------------------------------------------------------
    Route::post('cms/dashboard', 'App\Http\Controllers\Api\cms\DashboardController@index');

    // Yards
    Route::post('yards_list', 'App\Http\Controllers\Api\cms\YardController@index');
    Route::post('yards_create', 'App\Http\Controllers\Api\cms\YardController@store');
    Route::post('yards_show', 'App\Http\Controllers\Api\cms\YardController@show');
    Route::post('yards_update', 'App\Http\Controllers\Api\cms\YardController@update');
    Route::post('yards_delete', 'App\Http\Controllers\Api\cms\YardController@destroy');
    Route::post('yard_status', 'App\Http\Controllers\Api\cms\YardController@yard_status');
    Route::post('yards_filter', 'App\Http\Controllers\Api\cms\YardController@filter');


    // Blocks   
    Route::post('blocks_list', 'App\Http\Controllers\Api\cms\BlockController@index');
    Route::post('blocks_create', 'App\Http\Controllers\Api\cms\BlockController@store');
    Route::post('blocks_show', 'App\Http\Controllers\Api\cms\BlockController@show');
    Route::post('blocks_update', 'App\Http\Controllers\Api\cms\BlockController@update');
    Route::post('blocks_delete', 'App\Http\Controllers\Api\cms\BlockController@destroy');
    Route::post('blocks_status', 'App\Http\Controllers\Api\cms\BlockController@block_status');
    Route::post('blocksbyYard', 'App\Http\Controllers\Api\cms\BlockController@blocksbyYard');
    Route::post('block_container', 'App\Http\Controllers\Api\cms\BlockController@containers');
    Route::post('blocks_filter', 'App\Http\Controllers\Api\cms\BlockController@filter');
    Route::post('blocks_filter/by_yards', 'App\Http\Controllers\Api\cms\BlockController@filterWithYards');

    // Container Owners
    Route::post('cms/inventory/containers', 'App\Http\Controllers\Api\cms\ContainerOwnerController@getallContainers');
    Route::post('cms/trip/containers', 'App\Http\Controllers\Api\cms\ContainerOwnerController@getTripContainers');
    

    // CMS Purchase Order
    Route::post('cms/purchase/order/list', 'App\Http\Controllers\Api\cms\CmsPurchaseOrderController@purchaseOrderCmsList');
    Route::post('cms/purchase/order/details', 'App\Http\Controllers\Api\cms\CmsPurchaseOrderController@purchaseOrderCmsDetails');
    Route::post('cms/purchase/order/edit', 'App\Http\Controllers\Api\cms\CmsPurchaseOrderController@purchaseOrderCmsDetails');

    // Pre-Arrival
    Route::post('pre-arrival/list', 'App\Http\Controllers\Api\cms\PreArrivalController@index');
    Route::post('pre-arrival/details', 'App\Http\Controllers\Api\cms\PreArrivalController@details');
    Route::post('pre-arrival/create', 'App\Http\Controllers\Api\cms\PreArrivalController@store');
    Route::post('pre-arrival/approve', 'App\Http\Controllers\Api\cms\PreArrivalController@approveCreate');
    Route::post('pre-arrival/cancel', 'App\Http\Controllers\Api\cms\PreArrivalController@cancelPreArrival');
    Route::post('/pre-arrival/move-to-arrived', 'App\Http\Controllers\Api\cms\PreArrivalController@moveToArrived');
    Route::post('/pre-arrival/back-to-arrived', 'App\Http\Controllers\Api\cms\PreArrivalController@backToArrival');
    Route::post('arrival/pending', 'App\Http\Controllers\Api\cms\OrderController@pendingArrivedContainers');
    Route::post('pre-arrival/pending/lists', 'App\Http\Controllers\Api\cms\OrderController@pendingPreArrivedlist');


    // Arrived
    Route::post('arrival/list', 'App\Http\Controllers\Api\cms\ArrivalController@index');
    Route::post('arrival/details', 'App\Http\Controllers\Api\cms\ArrivalController@details');
    Route::post('arrival/create', 'App\Http\Controllers\Api\cms\ArrivalController@store');
    Route::post('arrival/{id}/create-pre-departure','App\Http\Controllers\Api\cms\ArrivalController@createPreDeparture');
    
       
    // Approval Arrival
    Route::post('arrival-approval/list', 'App\Http\Controllers\Api\cms\ApprovalController@index');
    Route::post('arrival-approval/details', 'App\Http\Controllers\Api\cms\ApprovalController@details');
    Route::post('arrival-approval/send', 'App\Http\Controllers\Api\cms\ApprovalController@sendForArrivalApproval');
    Route::post('arrival-approval/approve', 'App\Http\Controllers\Api\cms\ApprovalController@approveArrival');
    Route::post('arrival-approval/reject', 'App\Http\Controllers\Api\cms\ApprovalController@rejectArrivalApproval');

    // Orders
    Route::post('cms/orders/create/update', 'App\Http\Controllers\Api\cms\OrderController@ordersCreateUpdate');
    Route::post('cms/orders/list', 'App\Http\Controllers\Api\cms\OrderController@index');
    Route::post('cms/orders/details', 'App\Http\Controllers\Api\cms\OrderController@show');
    Route::post('cms/orders/pid/details', 'App\Http\Controllers\Api\cms\OrderController@pidOrders');
    Route::post('cms/orders/did/details', 'App\Http\Controllers\Api\cms\OrderController@didOrders');

    // Pre-Departure
    Route::post('pre-departure/list', 'App\Http\Controllers\Api\cms\PreDepartureController@index');
    Route::post('pre-departure/details', 'App\Http\Controllers\Api\cms\PreDepartureController@details');
    Route::post('pre-departure/create', 'App\Http\Controllers\Api\cms\PreDepartureController@store');
    Route::post('cms/pre-departure/move-to-departure', 'App\Http\Controllers\Api\cms\PreDepartureController@moveToDeparture');
    Route::post('cms/pre-departure/cancle', 'App\Http\Controllers\Api\cms\PreDepartureController@canclePreOrder');
 
    // Departures
    Route::post('departures/list', 'App\Http\Controllers\Api\cms\DepartureController@index');
    Route::post('departures/details', 'App\Http\Controllers\Api\cms\DepartureController@details');
    Route::post('cms/departures/send-for-approval', 'App\Http\Controllers\Api\cms\DepartureController@sendForDepartureApproval');

    // Approval Departure
    Route::post('departure-approval/list', 'App\Http\Controllers\Api\cms\ApprovalDepartureController@index');
    Route::post('departure-approval/details', 'App\Http\Controllers\Api\cms\ApprovalDepartureController@details');
    Route::post('cms/departure-approval/approved', 'App\Http\Controllers\Api\cms\ApprovalDepartureController@approveDeparture');
    Route::post('cms/departure-approval/reject', 'App\Http\Controllers\Api\cms\ApprovalDepartureController@rejectDeparture');
          
    // Upload Signs
    Route::post('cms/save-signature/arrival', 'App\Http\Controllers\Api\cms\UploadSignatureController@saveSignatureArrival');
    Route::post('cms/save-signature/departure', 'App\Http\Controllers\Api\cms\UploadSignatureController@saveSignatureDeparture');

    // Pending Order Containers
    Route::post('/pending/arrived/containers', 'App\Http\Controllers\Api\cms\OrderController@pendingArrivedContainers');
    Route::post('/pending/inventory/containers', 'App\Http\Controllers\Api\cms\OrderController@inventoryContainers');
    Route::post('/pending/predeparture/containers', 'App\Http\Controllers\Api\cms\OrderController@getPreDepartureContainers');

    Route::post('/orders/filter', 'App\Http\Controllers\Api\cms\OrderController@filter');
    Route::post('/orders/id', 'App\Http\Controllers\Api\cms\OrderController@fetchOrderByid');
    Route::post('/orders/mark-arrived/{id}', 'App\Http\Controllers\Api\cms\OrderController@markArrived');

    // pdf
    Route::post('/orders/pid/{id}/pdf', 'App\Http\Controllers\Api\cms\OrderController@pidOrdersPdf');
    Route::post('/orders/pid/gatepass/{id}/pdf', 'App\Http\Controllers\Api\cms\OrderController@pidOrderGatepassPdf');
    Route::post('/orders/did/{id}/pdf', 'App\Http\Controllers\Api\cms\OrderController@didOrdersPdf');
    Route::post('/orders/did/gatepass/{id}/pdf', 'App\Http\Controllers\Api\cms\OrderController@didOrderGatepassPdf');
    Route::post('/orders/create/arrival', 'App\Http\Controllers\Api\cms\OrderController@getArrivalOrder');
    Route::post('/orders/create/departure', 'App\Http\Controllers\Api\cms\OrderController@getDepartureOrder');


    //container_type
    Route::post('container_type', 'App\Http\Controllers\Api\cms\Masters\ContainerTypeController@index');
    Route::post('container_type/create', 'App\Http\Controllers\Api\cms\Masters\ContainerTypeController@store');
    Route::post('container_type/show', 'App\Http\Controllers\Api\cms\Masters\ContainerTypeController@show');
    Route::post('container_type/update', 'App\Http\Controllers\Api\cms\Masters\ContainerTypeController@update');
    Route::post('container_type/delete', 'App\Http\Controllers\Api\cms\Masters\ContainerTypeController@destroy');
    Route::post('container_type/status', 'App\Http\Controllers\Api\cms\Masters\ContainerTypeController@updateStatus');


    //container_condition
    Route::post('container_condition', 'App\Http\Controllers\Api\cms\Masters\ContainerConditionController@index');
    Route::post('container_condition/create', 'App\Http\Controllers\Api\cms\Masters\ContainerConditionController@store');
    Route::post('container_condition/update', 'App\Http\Controllers\Api\cms\Masters\ContainerConditionController@update');
    Route::post('container_condition/delete', 'App\Http\Controllers\Api\cms\Masters\ContainerConditionController@destroy');

    //Ports
    Route::post('ports', 'App\Http\Controllers\Api\cms\Masters\PortController@index');
    Route::post('ports/create', 'App\Http\Controllers\Api\cms\Masters\PortController@store');
    Route::post('ports/update', 'App\Http\Controllers\Api\cms\Masters\PortController@update');
    Route::post('ports/delete', 'App\Http\Controllers\Api\cms\Masters\PortController@destroy');

     //Gate pass
    Route::post('gatepass/list', 'App\Http\Controllers\Api\cms\GatePassController@indexAid');
    Route::post('gatepass-departure/list', 'App\Http\Controllers\Api\cms\GatePassController@indexDid');
        
  
    Route::middleware(['can:view-gatepass-aid'])->group(function () {
        Route::get('/gatepass/did', [GatePassController::class, 'indexDid'])->name('gatepass.indexDid');
    });

    //CMS Inventory Container List
    Route::post('cms/inventory/list', 'App\Http\Controllers\Api\cms\InventroyController@cmsInventoryList');

    // Container Tracking
    Route::post('tracking-container/list', 'App\Http\Controllers\Api\cms\ContainerStatusController@index');
    Route::post('tracking-close-container/list', 'App\Http\Controllers\Api\cms\ContainerStatusController@index_close');

    Route::post('/tracking/container/filter', [ContainerStatusController::class, 'filter'])->name('tracking.filter');
    Route::get('/tracking/close/container', [ContainerStatusController::class, 'index_close'])->name('tracking.index_close');
    Route::get('/tracking/container/create', [ContainerStatusController::class, 'create'])->name('tracking.create');
    Route::get('/tracking/container/edit/{id}', [ContainerStatusController::class, 'edit'])->name('tracking.edit');
    Route::post('/tracking/container/store', [ContainerStatusController::class, 'store'])->name('tracking.store');
    Route::post('/tracking/container/store/update', [ContainerStatusController::class, 'update'])->name('tracking.update');
    Route::get('/tracking/container/status/{id}', [ContainerStatusController::class, 'details'])->name('tracking.details');

    Route::post('/tracking/container/status/update', [ContainerStatusController::class, 'updateTrackingStatus'])->name('tracking-status.update');
    Route::post('/tracking/load/onTruck/status/update', [ContainerStatusController::class, 'updateLoadOnTruckStatus'])->name('tracking-status.update-on-truck');
    Route::get('/tracking/container/status', [ContainerStatusController::class, 'index_loaded_on_truck'])->name('tracking-status.index');
    Route::get('/tracking/container/create/truck', [ContainerStatusController::class, 'create_loaded_on_truck'])->name('tracking-status.create');
    Route::post('/tracking/container/truck/store', [ContainerStatusController::class, 'track_store'])->name('tracking-status.store');
    Route::post('/tracking/container/truck/update', [ContainerStatusController::class, 'track_update'])->name('tracking-status.track_update');
    Route::get('/tracking/container/truck/edit/{id}', [ContainerStatusController::class, 'edit_truck'])->name('tracking-status.edit_truck');
    Route::get('/tracking/container/loaded/{id}', [ContainerStatusController::class, 'truckDetails'])->name('tracking.truckDetails');

        // Import Excel For Pre Arrival
        Route::get('/import/arrival', [ImportController::class, 'import'])->name('arrival.import');
        Route::post('/import/upload/arrival', [ImportController::class, 'uploadImport'])->name('arrival.upload');
    
        // Import Excel For Pre Departure
        Route::get('/import/pre-departure', [ImportController::class, 'importPreDeparture'])->name('pre-departure.import');
        Route::post('/import/upload/pre-departure', [ImportController::class, 'uploadimportPreDeparture'])->name('pre-departure.upload');
    
        // Import Excel For Approval and Orders
        Route::get('/import/arrival/approval', [ImportController::class, 'importApproval'])->name('approval.import');
        Route::post('/import/upload/arrival/approval', [ImportController::class, 'uploadImportApproval'])->name('approval.upload');
    
        // Import Excel For Container Tracking
        Route::get('/import/container/tracking', [ImportController::class, 'importContainerTracking'])->name('tracking.import');
        Route::post('/import/upload/container/tracking', [ImportController::class, 'uploadContainerTracking'])->name('tracking.upload');
    

    // TMS --------------------------------------------------------------------------------------------------------------------------

    // Vehicles
    Route::post('tms/vehicle/create/update', 'App\Http\Controllers\Api\Tms\VehicleController@vehicleCreateUpdate');
    Route::post('item/vehicle/list', 'App\Http\Controllers\Api\Tms\VehicleController@vehicleList');
    Route::post('item/vehicle/details', 'App\Http\Controllers\Api\Tms\VehicleController@vehicleDetails');
    Route::post('tms/vehicle/installation', 'App\Http\Controllers\Api\Tms\VehicleController@vehicleInstallation');
    Route::post('tms/vehicle/tyre/config/update', 'App\Http\Controllers\Api\Tms\VehicleController@vehicleTyreConfiguration');
    Route::post('tms/vehicle/axle/config/update', 'App\Http\Controllers\Api\Tms\VehicleController@vehicleAxleConfiguration');
        //Documents Vehicle
    Route::post('tms/vehicle/document/create/update', 'App\Http\Controllers\Api\Tms\VehicleController@vehicleDocumentCreateUpdate');
    Route::post('tms/vehicle/documents/list', 'App\Http\Controllers\Api\Tms\VehicleController@vehicleDocumentsList');
    Route::post('tms/vehicle/documents/details', 'App\Http\Controllers\Api\Tms\VehicleController@vehicleDocumentDetails');
    Route::post('tms/vehicle/remove_trailer', 'App\Http\Controllers\Api\Tms\VehicleController@remove_trailer');
    Route::post('tms/vehicle/tyre/import', 'App\Http\Controllers\Api\Tms\VehicleController@tyreInstallation');

    // Trailers 
    Route::post('tms/trailer/create/update', 'App\Http\Controllers\Api\Tms\TrailerController@trailerCreateUpdate');
    Route::post('item/trailer/list', 'App\Http\Controllers\Api\Tms\TrailerController@trailerList');
    Route::post('item/trailer/details', 'App\Http\Controllers\Api\Tms\TrailerController@trailerDetails');
    Route::post('tms/trailer/installation', 'App\Http\Controllers\Api\Tms\TrailerController@trailerInstallation');
    Route::post('tms/trailer/tyre/config/update', 'App\Http\Controllers\Api\Tms\TrailerController@trailerTyreConfiguration');
    Route::post('tms/trailer/axle/config/update', 'App\Http\Controllers\Api\Tms\TrailerController@trailerAxleConfiguration');
    Route::post('tms/trailer/tyre/import', 'App\Http\Controllers\Api\Tms\TrailerController@tyreTrailerImported');

    //Documents Trailers
    Route::post('tms/trailer/document/create/update', 'App\Http\Controllers\Api\Tms\TrailerController@trailerDocumentCreateUpdate');
    Route::post('tms/trailer/documents/list', 'App\Http\Controllers\Api\Tms\TrailerController@trailerDocumentsList');
    Route::post('tms/trailer/documents/details', 'App\Http\Controllers\Api\Tms\TrailerController@trailerDocumentDetails');


    // Battery 
    Route::post('tms/battery/list', 'App\Http\Controllers\Api\Tms\BatteryController@batteryList');
    Route::post('tms/battery/stock/create', 'App\Http\Controllers\Api\Tms\BatteryController@batteryStockCreate');
    Route::post('tms/battery/stock/list', 'App\Http\Controllers\Api\Tms\BatteryController@batteryStockList');
    Route::post('tms/battery/stock/details', 'App\Http\Controllers\Api\Tms\BatteryController@batteryStockDetails');

    Route::post('tms/battery/move/history', 'App\Http\Controllers\Api\Tms\BatteryController@batteryHistoryCreate');
    Route::post('tms/battery/move/history/list', 'App\Http\Controllers\Api\Tms\BatteryController@batteryHistoryList');

    Route::post('tms/battery/service/history/create', 'App\Http\Controllers\Api\Tms\BatteryController@batteryServiceHistoryCreate');
    Route::post('tms/battery/service/history/list', 'App\Http\Controllers\Api\Tms\BatteryController@batteryServiceHistoryList');

    Route::post('tms/battery/inspection/history/create', 'App\Http\Controllers\Api\Tms\BatteryController@batteryInspectionHistoryCreate');
    Route::post('tms/battery/inspection/history/list', 'App\Http\Controllers\Api\Tms\BatteryController@batteryInspectionHistoryList');

    // Rim 
    Route::post('tms/rim/list', 'App\Http\Controllers\Api\Tms\RimController@rimList');
    Route::post('tms/rim/stock/create', 'App\Http\Controllers\Api\Tms\RimController@rimStockCreate');
    Route::post('tms/rim/stock/lists', 'App\Http\Controllers\Api\Tms\RimController@rim_stock_list');
    Route::post('tms/rim/stock/detail', 'App\Http\Controllers\Api\Tms\RimController@rim_stock_details');

    Route::post('tms/rim/move/history', 'App\Http\Controllers\Api\Tms\RimController@rimHistoryCreate');
    Route::post('tms/rim/move/history/list', 'App\Http\Controllers\Api\Tms\RimController@rimHistoryList');

    Route::post('tms/rim/service/history/create', 'App\Http\Controllers\Api\Tms\RimController@rimServiceHistoryCreate');
    Route::post('tms/rim/service/history/list', 'App\Http\Controllers\Api\Tms\RimController@rimServiceHistoryList');

    Route::post('tms/rim/inspection/history/create', 'App\Http\Controllers\Api\Tms\RimController@rimInspectionHistoryCreate');
    Route::post('tms/rim/inspection/history/list', 'App\Http\Controllers\Api\Tms\RimController@rimInspectionHistoryList');

    // Tyre 
    Route::post('tms/tyre/list', 'App\Http\Controllers\Api\Tms\TyreController@tyreList');
    Route::post('tms/tyre/stock/create', 'App\Http\Controllers\Api\Tms\TyreController@tyreStockCreate');
    Route::post('tms/tyre/stock/list', 'App\Http\Controllers\Api\Tms\TyreController@tyreStockList');
    Route::post('tms/tyre/stock/details', 'App\Http\Controllers\Api\Tms\TyreController@tyreStockDetail');

    Route::post('tms/tyre/move/history', 'App\Http\Controllers\Api\Tms\TyreController@tyreHistoryCreate');
    Route::post('tms/tyre/move/history/list', 'App\Http\Controllers\Api\Tms\TyreController@tyreHistoryList');

    Route::post('tms/tyre/service/history/create', 'App\Http\Controllers\Api\Tms\TyreController@tyreServiceHistoryCreate');
    Route::post('tms/tyre/service/history/list', 'App\Http\Controllers\Api\Tms\TyreController@tyreServiceHistoryList');

    Route::post('tms/tyre/inspection/history/create', 'App\Http\Controllers\Api\Tms\TyreController@tyreInspectionHistoryCreate');
    Route::post('tms/tyre/inspection/history/list', 'App\Http\Controllers\Api\Tms\TyreController@tyreInspectionHistoryList');

    // Tms Item Requestion
    Route::post('tms/requestion/create/update', 'App\Http\Controllers\Api\Tms\TmsRequestionController@createTmsRequestion');
    Route::post('tms/requestion/list', 'App\Http\Controllers\Api\Tms\TmsRequestionController@tmsRequestionList');
    Route::post('tms/requestion/details', 'App\Http\Controllers\Api\Tms\TmsRequestionController@tmsRequisitionDetails');
    Route::post('tms/requestion/delete', 'App\Http\Controllers\Api\Tms\TmsRequestionController@tms_requisition_delete');
    Route::post('tms/requestion/approval/list', 'App\Http\Controllers\Api\Tms\TmsRequestionController@tms_requestion_approval_list');
    Route::post('tms/stock/approval', 'App\Http\Controllers\Api\Tms\TmsRequestionController@tms_requisition_approval');
    Route::post('tms/stock/receive', 'App\Http\Controllers\Api\Tms\TmsRequestionController@tms_requisition_receive');

    // Tms Reports
    Route::post('report/tms/tyre', 'App\Http\Controllers\Api\Tms\DashboardController@totalTyreReport');
    Route::post('report/tms/tyre/depth', 'App\Http\Controllers\Api\Tms\DashboardController@tyreDepthReport');
    Route::post('report/tms/tyre/installed', 'App\Http\Controllers\Api\Tms\DashboardController@totalTyreInstalledReport');

    // Trip Management
    Route::post('trip/booking/create/update', 'App\Http\Controllers\Api\Trip\TripBookingController@tripBookingCreate');
    Route::post('trip/booking/list', 'App\Http\Controllers\Api\Trip\TripBookingController@tripBookingList');
    Route::post('trip/booking/details', 'App\Http\Controllers\Api\Trip\TripBookingController@tripBookingDetails');
    Route::post('trip/booking/status', 'App\Http\Controllers\Api\Trip\TripBookingController@tripBookingStatus');
    Route::post('trip/booking/delete', 'App\Http\Controllers\Api\Trip\TripBookingController@tripBookingdelete');



//    ------------------------------------------------------------------   ---------------------------------------------------- 
    // Workshop

    // Job Card
    Route::post('workshop/jobcard/create/update', 'App\Http\Controllers\Api\Workshop\JobCardController@jobCardCreateUpdate');
    Route::post('workshop/jobcard/lists', 'App\Http\Controllers\Api\Workshop\JobCardController@jobcardList');
    Route::post('workshop/jobcard/detail', 'App\Http\Controllers\Api\Workshop\JobCardController@jobCarddetails');
    Route::post('workshop/jobcard/status', 'App\Http\Controllers\Api\Workshop\JobCardController@jobCardStatus');

    // Inspection Template
    Route::post('workshop/inspection/template/create/update', 'App\Http\Controllers\Api\Workshop\WorkshopInspectionTemplateController@inspectionTemplateCreateUpdate');
    Route::post('workshop/inspection/template/list', 'App\Http\Controllers\Api\Workshop\WorkshopInspectionTemplateController@templateList');
    Route::post('workshop/inspection/template/detail', 'App\Http\Controllers\Api\Workshop\WorkshopInspectionTemplateController@inspectionTemplateDetails');
    Route::post('workshop/inspection/template/status', 'App\Http\Controllers\Api\Workshop\WorkshopInspectionTemplateController@inspectionTemplateStatus');
    Route::post('workshop/inspection/template/delete', 'App\Http\Controllers\Api\Workshop\WorkshopInspectionTemplateController@inspectionTemplateDelete');

    //Workshop Template Row
    Route::post('workshop/template/row/delete', 'App\Http\Controllers\Api\Workshop\WorkshopInspectionTemplateController@inspectionTemplateRowDelete');

    // Inspection
    Route::post('workshop/inspection/create/update', 'App\Http\Controllers\Api\Workshop\WorkshopInspectionController@inspectionCreateUpdate');
    Route::post('workshop/inspection/lists', 'App\Http\Controllers\Api\Workshop\WorkshopInspectionController@inspectionList');
    Route::post('workshop/inspection/detail', 'App\Http\Controllers\Api\Workshop\WorkshopInspectionController@inspectionDetails');
    Route::post('workshop/inspection/status', 'App\Http\Controllers\Api\Workshop\WorkshopInspectionController@inspectionStatusUpdate');
    Route::post('workshop/inspection/delete', 'App\Http\Controllers\Api\Workshop\WorkshopInspectionController@inspectionDelete');
    Route::post('workshop/inspection/checklist/delete', 'App\Http\Controllers\Api\Workshop\WorkshopInspectionController@inspectionChecklistDelete');

    // Workshop Estimates
    Route::post('workshop/estimates/display', 'App\Http\Controllers\Api\Workshop\WorkshopEstimatesController@getEstimates');
    Route::post('workshop/estimates/create/update', 'App\Http\Controllers\Api\Workshop\WorkshopEstimatesController@createEstimate');
    Route::post('workshop/estimates/lists', 'App\Http\Controllers\Api\Workshop\WorkshopEstimatesController@getAllEstimates');
    Route::post('workshop/estimates/details', 'App\Http\Controllers\Api\Workshop\WorkshopEstimatesController@getEstimateDetails');
    Route::post('workshop/estimates/delete', 'App\Http\Controllers\Api\Workshop\WorkshopEstimatesController@deleteEstimate');
    Route::post('workshop/estimates/approve', 'App\Http\Controllers\Api\Workshop\WorkshopEstimatesController@approveEstimate');
    Route::post('workshop/estimates/reject', 'App\Http\Controllers\Api\Workshop\WorkshopEstimatesController@rejectEstimate');

    // JOb Allocation
    Route::post('workshop/allocation/create/update', 'App\Http\Controllers\Api\Workshop\JobAllocationController@createJobAllocation');
    Route::post('workshop/allocation/lists', 'App\Http\Controllers\Api\Workshop\JobAllocationController@jobAllocationLists');
    Route::post('workshop/allocation/details', 'App\Http\Controllers\Api\Workshop\JobAllocationController@jobAllocationDetails');
    Route::post('workshop/allocation/start', 'App\Http\Controllers\Api\Workshop\JobAllocationController@jobAllocationStart');
    Route::post('workshop/allocation/end', 'App\Http\Controllers\Api\Workshop\JobAllocationController@jobAllocationEnd');
    Route::post('workshop/allocation/delayed', 'App\Http\Controllers\Api\Workshop\JobAllocationController@jobAllocationDelay');

    // Workshop Material Requestions
    Route::post('workshop/requestion/create/update', 'App\Http\Controllers\Api\Workshop\WorkshopMaterialRequestionController@createWorkshopRequestion');
    Route::post('workshop/requestion/lists', 'App\Http\Controllers\Api\Workshop\WorkshopMaterialRequestionController@workshopRequestionList');
    Route::post('workshop/requestion/details', 'App\Http\Controllers\Api\Workshop\WorkshopMaterialRequestionController@workshopRequisitionDetails');
    Route::post('workshop/requestion/delete', 'App\Http\Controllers\Api\Workshop\WorkshopMaterialRequestionController@workshop_requisition_delete');

    // Workshop Material Requestions Items
    Route::post('workshop/requestion/item/list', 'App\Http\Controllers\Api\Workshop\WorkshopMaterialRequestionController@requestion_approval_list');
    Route::post('workshop/stock/approval', 'App\Http\Controllers\Api\Workshop\WorkshopMaterialRequestionController@requisition_approval');
    Route::post('workshop/stock/receive', 'App\Http\Controllers\Api\Workshop\WorkshopMaterialRequestionController@requisition_receive');

    //Workshop Store
    Route::post('workshop/store/create/update', 'Api\Workshop\WorkshopStoreController@createUpdate');
    Route::post('workshop/store/list', 'Api\Workshop\WorkshopStoreController@list');
    Route::post('workshop/store/status', 'Api\Workshop\WorkshopStoreController@status');
    Route::post('workshop/store/details', 'Api\Workshop\WorkshopStoreController@details');
    Route::post('workshop/stock/list', 'Api\Workshop\WorkshopStoreController@stockTransactionStore');
        
}); 









