<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('inspire')->hourly();
        $schedule->call(function () {
            $stocks = Stock::all();
            foreach ($stocks as $stock) {
                if ($stock->quantity <= $stock->threshold) {
                    $usersToAlert = User::whereHas('stockAlerts', function ($query) use ($stock) {
                        $query->where('stock_id', $stock->id);
                    })->get();
                    foreach ($usersToAlert as $user) {
                        // Send notification to $user
                    }
                }
            }
        })->everyMinute();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
