<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use App\Models\Category;
use App\Service\ActivityService;

class CategoryController extends Controller
{
    public function categoryCreateUpdate(Request $request){

        $user=Auth::user();

        // Validate Item
        $validator=validator($request->all(),[
            'name'=>'required|string',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            $category=[];

            $obj['name']=$request['name'];
            $obj['fullurl']=$request['fullurl'];
            $obj['parent_id']=$request['parent_id']??0;
            $obj['description']=$request['description'];
            $obj['title']=$request['title'];

            if($request['id'] >0){

                try{

                    // Existing Id Then Update
                    $category=Category::findOrFail($request['id']);
                    $category->update($obj);

                    // Creating Activities
                    $activity=new ActivityService;
                    $activity->activityCreateUpdate('Category',$category['id'],'Updated');
                    
                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                    // Return error message in JSON if ID not found
                    return response()->json(['message' => 'Invalid Id to update '], 404);
                }

            }else{

                // Check if Duplicate Category
                if($obj['name'] != null && $obj['name'] != ''){
                    $checkName = Category::where('name', $obj['name'])
                                    ->where('is_disabled', 0);

                    if($obj['parent_id']==0){

                        //check on category
                        $checkName = $checkName->where('parent_id',0);
                    }else{
                        //check on sub category
                        $checkName = $checkName->where('parent_id', $obj['parent_id']);
                    }

                    $checkName = $checkName->first();
                
                    if($checkName != null){
                        $response = [
                            'category' => $checkName,
                            'success' => false,
                            'message' => 'Duplicate Name '. $checkName['name'] .' Found!'
                        ];
                
                        return response()->json($response);
                    }
                }

                // Create new Category
                $category=Category::create($obj);

                // Creating Activities
                $activity=new ActivityService;
                $activity->activityCreateUpdate('Category',$category['id'],'Created');
            }
            $response=[
                'success'=>true,
                'message'=>$request['id']>0? "Category Updated Successfully":"Category Created Successfully",
                'data'=>$category
            ];
        }

        return response()->json($response);
    }


    public function categoryList(Request $request){

        $user=Auth::user();
        
        $category=Category::where('parent_id',0)
            ->where('is_disabled',0)
            ->with('sub_category');

        if(isset($request['id']) && $request['id']>0){
            $category=$category->where('id',$request['id']);
        }

        if(isset($request['active']) && $request['active']!=''){
            $category=$category->where('active',$request['active']);
        }

        if($request['search']!=null && $request['search']!=''){

            $category = $category->where(function ($query) use ($request) {

                $query->where('name', 'LIKE', '%' . $request['search'] . '%')

                ->orWhereHas('sub_category', function ($query) use ($request) {
                    $query->where('name', 'LIKE', '%' . $request['search'] . '%');
                });
            });
        }

        $count=$category->count();

        $category =$category->orderBy('id','desc')
            ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
            ->get();

        $response=[
            'success'=>true,
            'total'=>$count,
            'data'=>$category
        ];

        return response()->json($response);
    }

    public function subCategoryList(Request $request){
        $user=Auth::user();
        
        $category=Category::where('parent_id','>',0)
            ->where('is_disabled',0)
            ->with('parent_category');

        if(isset($request['id']) && $request['id']>0){
            $category=$category->where('id',$request['id']);
        }

        if(isset($request['name']) && $request['name']>0){
            $category=$category->where('name','LIKE','%'.$request['name'].'%');
        }

        $count=$category->count();

        $category =$category->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
            ->get();

        $response=[
            'success'=>true,
            'total'=>$count,
            'data'=>$category
        ];

        return response()->json($response);
    } 


    public function delete(Request $request){
        $user=Auth::user();

        // Validate Item
        $validator=validator($request->all(),[
            'id'=>'required',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            try{
                $item = Category::where('id', $request->input('id'))
                    ->firstOrFail(); // Use firstOrFail() to throw ModelNotFoundException if not found
    
                $item->is_disabled = 1;
                $item->save(); // Use save() method to persist changes to the database
            
                $response = [
                    'success' => true,
                    'message' => 'Category Deleted successfully.'
                ];
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['message' => 'Invalid Id to update '], 404);
            }

            return response()->json($response);
        }
    }


    public function status(Request $request){
        $user=Auth::user();

        // Validate Item
        $validator=validator($request->all(),[
            'id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            try{
                $item = Category::where('id', $request->input('id'))
                    ->firstOrFail(); // Use firstOrFail() to throw ModelNotFoundException if not found
    
                $item->active = $request['active'];
                $item->save(); // Use save() method to persist changes to the database
            
                $response = [
                    'success' => true,
                    'message' => 'Category Status Updated successfully.'
                ];
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['message' => 'Invalid Id to update '], 404);
            }

            return response()->json($response);
        }
    }

}
