<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\OrganisationRolePermission;
use App\Models\UserOrganisation;
use Auth;
use Log;
use App\Service\ActivityService;

class OrganisationRoleController extends Controller
{
    public function createOrganisationRole(Request $request){

        $user=Auth::user();
        // Validate the request data
        $validator = \Validator::make($request->all(), [
            'name' => 'required',
            'permissions'=>'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'errors' => $validator->getMessageBag()
            ], 422);
        }

        $obj['name']=$request['name'];
        $obj['permissions']=json_encode($request['permissions']);
        $obj['description']=$request['description'];

        if($request['id']>0){
            // Update existing role
            $role=OrganisationRolePermission::findOrFail($request['id']);
            $role->update($obj);

            // Creating Activities
            $activity=new ActivityService;
            $activity->activityCreateUpdate('Organisation Role Permission',$role['id'],'Updated');

        }else{
            // Create new role
            $check=OrganisationRolePermission::where('organisation_id',$user['active_organisation'])
                ->where('name',$request['name'])->first();
            
            if($check!=null){
                $response=[
                    'message'=>'Role Already Created',
                    'success'=>false,
                    'data'=>$check
                ];
        
                return response()->json($response);
            }else{
                $role=OrganisationRolePermission::create($obj);

                // Creating Activities
                $activity=new ActivityService;
                $activity->activityCreateUpdate('Organisation Role Permission',$role['id'],'Created');
            }
           
        }

        $response=[
            'message'=>'Role Created Successfully',
            'success'=>true,
            'data'=>$role,
        ];

        return response()->json($response);
    }

    public function getLoggedInRoles(Request $request){
        $user=Auth::user();

        Log::info($user['active_organisation']);
        Log::info($user['id']);
        $role=OrganisationRolePermission::where('organisation_id',$user['active_organisation'])
            ->get();

        // if($role==null)
        // return response()->json(['data'=>$role, 'success'=>true'The user does not have a role in this organisation']);

        return response()->json(['data'=>$role, 'success'=>true]);
        
    }

    public function delete(Request $request){
        $user=Auth::user();

        $validator = \Validator::make($request->all(), [
            'id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'errors' => $validator->getMessageBag()
            ], 422);
        }

        $user_organisation=UserOrganisation::where('user_id',$user['id'])
                ->where('organisation_id',$user['active_organisation'])
                ->first();

        if($user_organisation['is_owner']==1){

            $role=OrganisationRolePermission::where('id',$request['id'])
                ->first();

            $role->delete();

             // Creating Activities
             $activity=new ActivityService;
             $activity->activityCreateUpdate('Organisation Role Permission',$role['id'],'Deleted');

            $response=[
                'message'=>'Role Deleted Successfully',
                'success'=>true,
            ];
            
        }else{
            $response=[
                'message'=>'You are not an Owner to delete role',
                'success'=>false,
            ];
        }

        return response()->json($response);

    }

}
