<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;

class ReportController extends Controller
{

    public function getCountsReport(Request $request)
    {
        $base = User::where('is_disabled', 0);

        // CUSTOMER
        $customerQuery = (clone $base)->where('is_customer', 1);
        $customerCounts = [
            'total'     => (clone $customerQuery)->count(),
            'draft'     => (clone $customerQuery)->where('status', 0)->count(),
            'active'    => (clone $customerQuery)->where('status', 1)->count(),
            'inactive'  => (clone $customerQuery)->where('status', 2)->count(),
            'suspended' => (clone $customerQuery)->where('status', 3)->count(),
        ];

        // USER
        $userQuery = (clone $base)->where('is_user', 1);
        $userCounts = [
            'total'     => (clone $userQuery)->count(),
            'draft'     => (clone $userQuery)->where('status', 0)->count(),
            'active'    => (clone $userQuery)->where('status', 1)->count(),
            'inactive'  => (clone $userQuery)->where('status', 2)->count(),
            'suspended' => (clone $userQuery)->where('status', 3)->count(),
        ];

        // VENDOR
        $vendorQuery = (clone $base)->where('is_vendor', 1);
        $vendorCounts = [
            'total'     => (clone $vendorQuery)->count(),
            'draft'     => (clone $vendorQuery)->where('status', 0)->count(),
            'active'    => (clone $vendorQuery)->where('status', 1)->count(),
            'inactive'  => (clone $vendorQuery)->where('status', 2)->count(),
            'suspended' => (clone $vendorQuery)->where('status', 3)->count(),
        ];

        return response()->json([
            'message'   => 'Successful',
            'customer'  => $customerCounts,
            'users'     => $userCounts,
            'vendors'   => $vendorCounts,
        ]);
    }

}

