<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\RequestDemo;

class RequestDemoController extends Controller
{
    public function createUpdateRequestDemo(Request $request)
    {
        $validator=validator($request->all(),[
            'form_type'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];
        } else {
            $obj['name']=$request['name'];
            $obj['first_name']=$request['first_name'];
            $obj['last_name']=$request['last_name'];
            $obj['email']=$request['email'];
            $obj['mobile_no']=$request['mobile_no'];
            $obj['company_name']=$request['company_name'];
            $obj['message']=$request['message'];

            // Join as a vendor

            $obj['form_type']=$request['form_type'];  // contact_us ,vendor_form , demo_form
            $obj['services_offered']=$request['services_offered'];
            $obj['contact_person']=$request['contact_person'];
            $obj['street_1']=$request['street_1'];
            $obj['street_2']=$request['street_2'];
            $obj['country_name']=$request['country_name'];
            $obj['state_name']=$request['state_name'];
            $obj['city_name']=$request['city_name'];
            $obj['pincode']=$request['pincode'];

            $requestDemo = RequestDemo::create($obj);
            return [
                'success' => true, 
                'message' => 'Demo Requested successfully',
            ];
        }
    }

    public function getRequestDemo(Request $request)
    {
        $requestDemo = RequestDemo::query();

        if($request['form_type'] && $request['form_type'] != null) {
            $requestDemo->where('form_type', $request['form_type']);
        }

        $count = $requestDemo->count();

        $requestDemo = $requestDemo->orderBy('id', 'desc')
           ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??50)
            ->get();

        return [
            'success' => true, 
            'message' => 'Demo Requested successfully',
            'count' => $count,
            'data' => $requestDemo
        ];
    }
}
