<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use App\Models\Status;
use App\Service\ActivityService;

class StatusController extends Controller
{
    public function statusCreateUpdate(Request $request){

        $user=Auth::user();

        // Validate Item
        $validator=validator($request->all(),[
            'name'=>'required|string',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            $status=[];

            $obj['name']=$request['name'];
            $obj['fullurl']=$request['fullurl'];
            $obj['parent_id']=$request['parent_id']??0;
            $obj['description']=$request['description'];
            $obj['title']=$request['title'];

            if($request['id'] >0){

                try{

                    // Existing Id Then Update
                    $status=Status::findOrFail($request['id']);
                    $status->update($obj);

                    // Creating Activities
                    // $activity=new ActivityService;
                    // $activity->activityCreateUpdate('status',$status['id'],'Updated');
                    
                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                    // Return error message in JSON if ID not found
                    return response()->json(['message' => 'Invalid Id to update '], 404);
                }

            }else{

                // Check if Duplicate status
                if($obj['name'] != null && $obj['name'] != ''){
                    $checkName = Status::where('name', $obj['name'])
                                    ->where('is_disabled', 0);

                    if($obj['parent_id']==0){

                        //check on status
                        $checkName = $checkName->where('parent_id',0);
                    }else{
                        //check on sub status
                        $checkName = $checkName->where('parent_id', $obj['parent_id']);
                    }

                    $checkName = $checkName->first();
                
                    if($checkName != null){
                        $response = [
                            'status' => $checkName,
                            'success' => false,
                            'message' => 'Duplicate Name '. $checkName['name'] .' Found!'
                        ];
                
                        return response()->json($response);
                    }
                }

                // Create new status
                $status=Status::create($obj);

                // Creating Activities
                // $activity=new ActivityService;
                // $activity->activityCreateUpdate('status',$status['id'],'Created');
            }
            $response=[
                'success'=>true,
                'message'=>$request['id']>0? "Status Updated Successfully":"Status Created Successfully",
                'data'=>$status
            ];
        }

        return response()->json($response);
    }


    public function statusList(Request $request){

        $user=Auth::user();
        
        $status=Status::where('parent_id',0)
            ->where('is_disabled',0)
            ->with('sub_status');

        if(isset($request['id']) && $request['id']>0){
            $status=$status->where('id',$request['id']);
        }

        if(isset($request['active']) && $request['active']!=''){
            $status=$status->where('active',$request['active']);
        }

        if($request['search']!=null && $request['search']!=''){

            $status = $status->where(function ($query) use ($request) {

                $query->where('name', 'LIKE', '%' . $request['search'] . '%')

                ->orWhereHas('sub_status', function ($query) use ($request) {
                    $query->where('name', 'LIKE', '%' . $request['search'] . '%');
                });
            });
        }

        $count=$status->count();

        $status =$status->orderBy('id','asc')
            ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
            ->get();

        $response=[
            'success'=>true,
            'total'=>$count,
            'data'=>$status
        ];

        return response()->json($response);
    }

    public function substatusList(Request $request){
        $user=Auth::user();
        
        $status=Status::where('parent_id','>',0)
            ->where('is_disabled',0)
            ->with('parent_status');

        if(isset($request['id']) && $request['id']>0){
            $status=$status->where('id',$request['id']);
        }

        if(isset($request['name']) && $request['name']>0){
            $status=$status->where('name','LIKE','%'.$request['name'].'%');
        }

        $count=$status->count();

        $status =$status->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
            ->get();

        $response=[
            'success'=>true,
            'total'=>$count,
            'data'=>$status
        ];

        return response()->json($response);
    } 


    public function delete(Request $request){
        $user=Auth::user();

        // Validate Item
        $validator=validator($request->all(),[
            'id'=>'required',
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            try{
                $item = Status::where('id', $request->input('id'))
                    ->firstOrFail(); // Use firstOrFail() to throw ModelNotFoundException if not found
    
                $item->is_disabled = 1;
                $item->save(); // Use save() method to persist changes to the database
            
                $response = [
                    'success' => true,
                    'message' => 'status Deleted successfully.'
                ];
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['message' => 'Invalid Id to update '], 404);
            }

            return response()->json($response);
        }
    }


    public function status(Request $request){
        $user=Auth::user();

        // Validate Item
        $validator=validator($request->all(),[
            'id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            try{
                $item = Status::where('id', $request->input('id'))
                    ->firstOrFail(); // Use firstOrFail() to throw ModelNotFoundException if not found
    
                $item->active = $request['active'];
                $item->save(); // Use save() method to persist changes to the database
            
                $response = [
                    'success' => true,
                    'message' => 'status Status Updated successfully.'
                ];
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
                // Return error message in JSON if ID not found
                return response()->json(['message' => 'Invalid Id to update '], 404);
            }

            return response()->json($response);
        }
    }

}
