<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use App\Models\UserInvite;
use App\Models\UserOrganisation;
use Illuminate\Support\Facades\Mail;
use App\Models\User;
use Illuminate\Support\Str;
use Validator;
use Log;

class UserInvitationController extends Controller
{
    public function createInvitation(Request $request){
       
        $user=Auth::user();

        // Validate the request data
          // Validate Item
          $validator=validator($request->all(),[
            'name'=>'required|string',
            'email'=>'required',
            'role'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            $check_invitation=UserInvite::where('email',$request->input('email'))
                ->where('organisation_id',$user['active_organisation'])
                ->first();
            
            if($check_invitation!=null && $check_invitation->is_invited==0) {  

                return response()->json(['success'=>false,'message'=>"You Have Already Invited this User"]); 

            } elseif ($check_invitation != null && $check_invitation->is_invited == 1) {

                return response()->json(['success'=>false,'message'=>"This invitation has been used."]);

            } else {

                // Create a new user invitation and save it in the database
                $obj['name']=$request['name'];
                $obj['email']=$request['email'];
                $obj['role']=$request['role'];
                $obj['mobile_no']=$request['mobile_no'];

                // Generating Random token
                $token = Str::random(20);

                // Updating Random Token to Invite table
                $obj['invite_url']=$token;

                // Sending Email for Verification
                $data['email'] = $request['email'];
                $data['title'] = "Invitation Link TO Join Organisation";
                $data['body'] = 'Welcome to the Accounting Software';
                $data['link']='https://devs-erp-accounts.vercel.app/invitation-mail/'.$token;
                Mail::send('mail.verifyMail', ['data' => $data], function ($message) use ($data) {
                    $message->to($data['email'])->subject($data['title']);
                });

                //Creating new Entry For User 
                $user_invite=UserInvite::create($obj);

                $response=[
                    'success'=>true,
                    'message'=>'Invitation Send Successfully'
                ];

                return  response()->json($response);
            }
        }
    }

    // User Hit a link in mail 
    public function invitationLogin(Request $request){
        
        // Get all of the authenticated user's invites
        $validator=validator($request->all(),[
            'token' => ['required', 'string', 'max:255'],
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            // Check given token exist in Invitation table
            $user_invite=UserInvite::where('invite_url',$request['token'])
                ->first();

            if($user_invite!=null && $user_invite->is_invited==0){

                // If Not Clicked on link
                $obj['name']=$user_invite['name'];
                $obj['email']=$user_invite['email'];
                $obj['mobile_no']=$user_invite['mobile_no'];
                $obj['primary_organisation']=$user_invite['organisation_id'];
                $obj['active_organisation']=$user_invite['organisation_id'];
                $obj['organisation_id']=$user_invite['organisation_id'];

                $user=User::where('email',$user_invite['email'])->first();

                Log::info('123'.$user);
                if($user==null){

                    // if User not exists on User Table
                    $user=User::create($obj);
                }

                // creating Access token  for the user.
				$accessToken = $user->createToken('my-app-token')->plainTextToken;

                Log::info('456'.$user);

				// Logged User
				Auth::login($user);

                 // create default Owner Role
                $user_org['user_id']=$user['id'];
                $user_org['is_owner']=0;
                $user_org['organisation_id']=$user['organisation_id'];
                $user_org['role']=$user_invite['role'];

                UserOrganisation::create($user_org);

                $user_invite['is_invited']=1;
                $user_invite->update();

                $response = [
                    'access_token'=>$accessToken,
                    'user'=>$user,
                    'success' => true,
                    'message' => 'User Created Successfullly',
                ];

            } elseif($user_invite!=null && $user_invite->is_invited==1){

                $response = [
                    'access_token'=>null,
                    'user'=>null,
                    'success' => false,
                    'message' => 'Already Used Link , Please Login',
                ];

            } else {

                $response = [
                    'access_token'=>null,
                    'user'=>null,
                    'success' => false,
                    'message' => 'Un-Authorised Access Detected',
                ];
            }

            return response()->json($response);
            
        }
    }

    public function userInvitationList(Request $request){
        $user=Auth::user();

        $user_invite=UserInvite::where('organisation_id',$user['active_organisation'])
            ->get();

        $response=[
            'data'=>$user_invite,
            'success'=>true,
            'message'=>'User invites list fetch successful'
        ];

        return response()->json($response);
    }
}
