<?php

namespace App\Http\Controllers\Manufacturing;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use App\Models\Batch;

class BatchesController extends Controller
{
    public function index(Request $request)
    {
        $query = Batch::where('rolledback',0)
            ->with('entry_by:id,name');

        if ($request->has('search')) {
            $search = $request->input('search');
            $query->where(function($q) use ($search) {
                $q->where('date', 'like', '%' . $search . '%')
                  ->orWhere('batch_number', 'like', '%' . $search . '%')
                  ->orWhere('notes', 'like', '%' . $search . '%')
                  ->orWhere('status', 'like', '%' . $search . '%');
            });
        }

        if ($request->has('status')) {
            $status = $request->input('status');
            $query->where('status', $status);
        }

        if ($request->has('is_active')) {
            $is_active = $request->input('is_active');
            $query->where('is_active', $is_active);
        }

        if ($request['specific_date']!='' && isset($request['specific_date'])) {

            $customDate = $request->specific_date;

            $query = $query->whereDate('date', $customDate);

        }

        if ($request['from_date']!='' && isset($request['to_date'])) {

            $fromDate = $request->from_date;

            $toDate = $request->to_date;

            // 'fromDate' and 'toDate'
            $query = $query->whereBetween('date', [$fromDate, $toDate]);

        }

        $count=$query->count();

        if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
                
            $sort_order=$request['order_by']==1?'asc':'desc';

            $query = $query->orderby($request['sort_by'],$sort_order);

        }else{
            $query = $query->orderby('id','desc');
        }
        
        $batches=$query->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??50)
                ->orderBy('id','desc')
                ->get();

        return $response=[
            'success'=>true,
            'total'=>$count,
            'batches'=>$batches,
            'message'=>'All Batches Listed Successfully'
        ];
    
    }

    // Store a newly created machinery item
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'batch_number' => 'required',
           
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 400);
        }
        // return $request;

       $dump= DB::table('batches')->insert([
            'date' => $request->input('date' ?? ''),
            'batches_id' => $request->input('batches_id' ?? ''),
            'batch_number' => $request->input('batch_number' ?? ''),
            'notes' => $request->input('notes' ?? ''),
            'status' => $request->input('status' ?? 0),
        ]);


        return response()->json(['message' => 'Batch created successfully'], 201);
    }

    // Display the specified machinery item
    public function show(Request $request)
    {
        $id= $request->id;
        $machine = DB::table('batches')
                     ->where('id', $id)
                     ->first();

        if (!$machine) {
            return response()->json(['message' => 'Batch not found'], 404);
        }

        return response()->json($machine);
    }

    // Update the specified machinery item
    public function update(Request $request)
    {

        $id= $request->id;

        $affected = DB::table('batches')
                      ->where('id', $id)
                      ->update([
                           'date' => $request->input('date' ?? ''),
                        'batch_number' => $request->input('batch_number' ?? ''),
                        'batches_id' => $request->input('batches_id' ?? ''),
                        'notes' => $request->input('notes' ?? ''),
                        'status' => $request->input('status' ?? 0),
                      ]);

        if ($affected === 0) {
            return response()->json(['message' => 'Batch not found or no changes made'], 404);
        }

        return response()->json(['message' => 'Batch updated successfully']);
    }

    // Remove the specified machinery item
    public function destroy($id)
    {
        $affected = DB::table('machinery')->where('machine_id', $id)->delete();

        if ($affected === 0) {
            return response()->json(['message' => 'Machinery item not found'], 404);
        }

        return response()->json(['message' => 'Machinery item deleted successfully']);
    }

    // Update status Active and In Active
    public function status(Request $request){

        // Validate Item

        $validator=validator($request->all(),[
           'batch_id'=>'required|integer',
           'is_active'=>'required|integer'
       ]);

       if ($validator->fails()) { 

           return [
               'success' => false, 
               'message' => $validator->errors()->first(),
           ];

       } else {

           try{

               $batch =  Batch::where('id',$request->input('batch_id'))->first();

               $batch['is_active']=$request['is_active'];

               $batch->update();

               $response=[
                   'success'=>true,
                   'message'=>'Batch Status Updated successfully.'
               ];

           } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

               // Return error message in JSON if ID not found
               return response()->json(['message' => 'Invalid Id found'], 404);
           }

           return response()->json($response);

       }

   }
}
