<?php

namespace App\Http\Controllers\Manufacturing;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class MasterController extends Controller
{
    // Fetch all records from a master table
    public function index($table)
    {
        $records = DB::table($table)->where('status', 1)->get();
        return response()->json($records);
    }

    // Fetch a single record by ID
    public function show($table, $id)
    {
        $record = DB::table($table)->where('id', $id)->first();
        return response()->json($record);
    }

    // Create a new record
    public function store(Request $request, $table)
    {
        $id = DB::table($table)->insertGetId([
            'name' => $request->name,
        ]);
        return response()->json(['id' => $id], 201);
    }

    // Update an existing record
    public function update(Request $request, $table)
    {
        $id = $request->id;
        DB::table($table)->where('id', $id)->update([
            'name' => $request->name,
        ]);
        
        return response()->json(['message' => 'Record updated successfully']);
    }

    // Delete a record (soft delete by setting status to 0)
    public function destroy($table, $id)
    {
        DB::table($table)->where('id', $id)->update(['status' => 0]);
        return response()->json(['message' => 'Record deleted successfully']);
    }
}
