<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;


class Item extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function sluggable():array
    {
    	return ['url_name' => ['source' => 'name']];
    }

    
    public function category(){
        return $this->belongsTo('App\Models\Category','category_id');
    }

    public function sub_category(){
        return $this->belongsTo('App\Models\Category','sub_category_id');
    }
}
