# Accounting Backend (SCMD)

<p align="center"><a href="https://laravel.com" target="_blank"><img src="https://raw.githubusercontent.com/laravel/art/master/logo-lockup/5%20SVG/2%20CMYK/1%20Full%20Color/laravel-logolockup-cmyk-red.svg" width="400" alt="Laravel Logo"></a></p>

<p align="center">
<a href="https://github.com/laravel/framework/actions"><img src="https://github.com/laravel/framework/workflows/tests/badge.svg" alt="Build Status"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/dt/laravel/framework" alt="Total Downloads"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/v/laravel/framework" alt="Latest Stable Version"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/l/laravel/framework" alt="License"></a>
</p>

## Introduction

Welcome to our project's Source Code Management (SCM) documentation. This guide aims to provide detailed insights into our PHP Laravel project's structure, versioning, touched files, utilized packages, and folder structure. This document is designed to help new developers quickly understand the project's architecture and contribute effectively.

### Language
PHP

Our project is primarily developed using the PHP programming language, leveraging the powerful features and ecosystem of PHP for web development.

**Version**
- PHP version: 8.1.17

### Folder Structure

<details>
<summary>Folder Structure</summary>

```
project-name/
├── app/
│   ├── Console/
│   ├── Exceptions/
│   ├── Http/
│   │   ├── Controllers/
│   │   ├── Middleware/
│   │   └── Requests/
│   ├── Models/
│   └── Providers/
├── config/
├── database/
│   ├── factories/
│   ├── migrations/
│   └── seeds/
├── public/
├── resources/
│   ├── lang/
│   ├── views/
│   └── assets/
├── routes/
├── storage/
└── tests/
```

</details>

**Touched/Project Files**

<details>
<summary>Touched/Project Files</summary>

Here are the main types of files you'll encounter in our project:

- **Models**
  - `Account.php` - Manages and represents Accounting information data.
  - `Activity.php` - Manages and store all the activities like Create, update, delete, Import, export, etc.
  - `Address.php`: Represents user's Addresses data and handles users relationship.
  - `AgainstPayment.php`: Represents all the payments which are against invoices and bills and handle the relationship with Payments.
  - `Bill.php`: Manages All data of purchases, items , taxes against vendors.
  - `BillItem.php`: Manages All the items of bills and maintain realationship with bills.
  - `Category.php`: Manages and represents all the category and parent category of items.
  - `City.php`: Represents all the City of states.
  - `ContactPerson.php`: Represents and Manages all the Customers and vendors Contact Person information.
  - `Country.php`: Represents all the data  related to countries.
  - `CreditNote.php`: Represents and manages Credit note data.
  - `CreditNoteItem.php`: Represents and Manages Credit Note Items and Manages relationship with  credit notes.
  - `Currency.php`:   Handles Currencies Data.
  - `CustomField.php`:   Handles custom field for Invoice, Bill and others.
  - `DailyStock.php`:   Daily Stock report which shows daily stock summary.
  - `DebitNote.php`:   Debit Note is a document issued by supplier to customer for return or cancellation of                      purchased goods or services.
  - `DebitNoteItem.php`:   Debit Note Item is used when we create a debit note from an existing bill item.
  - `Expense.php`:   Expenses management model.
  - `ExpenseHead.php`:  Used to manage expense head i.e where money will be spent on.
  - `Invoice.php`:  Represents and manages all the Invoices against customer or cash.
  - `InvoiceItem.php`:  Each line item of an Invoice belongs to Invoice Item.
  - `Item.php`:   It is used to represent any type of product or service that can be sold or purchased by the company.
  - `Journal.php`: Journal Entry Model.
  - `JournalEntry.php`:  Single Line entry of journal.
  - `Master.php`:  Master model that includes all other models as child.
  - `OpeningBalance.php`: It represents all the  opening balance transactions.
  - `Organisation.php`: Manages All Organisation Information Model.
  - `OrganisationRolePermission.php`:  Handles Role Permission for Users against Organisation.
  - `PasswordReset.php`:  Password Reset Token Model.
  - `Payment.php`:  It Manages all the payments  made by customers and vendors.
  - `PurchaseItemTax.php`:  Purchase Item Tax is used when we add new tax to purchase item.
  - `PurchaseOrder.php`: It manages all the purchase order details.
  - `PurchaseOrderItem.php`:  Each line item of a Purchase Order belongs to PurchaseOrderItem.
  - `Quotation.php`:  Quotation Management Model.
  - `QuotationItem.php`:   Each line item of a quotation belongs to QuotationItem.
  - `SaleItemTax.php`:   Sale Item Tax is used when we add new tax to sale item.
  - `SaleOrder.php`:  This is the sales order model.
  - `SaleOrderItem.php`:   Each line item of a Sales Order belongs to SaleOrderItem.
  - `State.php`:   Represents all the State of countries.
  - `StockTransaction.php`:   It represents each transaction done in stock like Add/Subtract Qty, Adjustment etc.
  - `Tax.php`:   Handles all the taxes added to any transaction.
  - `User.php`: Represents user data and handles authentication.
  - `UserInvite.php`:  User Invitation class.
  - `UserOrganisation.php`:   Handles the relation between user and organisation.
  - `Warehouse.php`: It manages all the  warehouses of the organisation


- **Controllers**
  - `AccountController.php` : Contains API's for Account Transactions.
  - `AddressController.php` :
  - `CategoryController.php` :
  - `CreditDebitController.php` :
  - `CustomerController.php` :
  - `CustomFieldController.php` :
  - `ExpenseController.php` :
  - `ItemController.php` :
  - `JournalController.php` :
  - `MasterController.php` :
  - `OpeningBalanceController.php` :
  - `OrganisationController.php` :
  - `OrganisationRoleController.php` :
  - `PaymentController.php` :
  - `ProductController.php` :
  - `ProfileController.php` :
  - `PurchaseTransactionController.php` :
  - `SaleTransactionController.php` :
  - `StockTransactionController.php` :
  - `TaxController.php` :
  - `TestController.php` :
  - `TicketController.php` :
  - `TransactionController.php` :
  - `UserController.php` :
  - `UserInvitationController.php` :
  - `VendorController.php` :
  - `WarehouseController.php` :
  <!-- - `UserController.php`: Handles user-related actions such as registration and login.
  - `ItemsController.php`: Manages CRUD operations for items.
  - `OrganisationController.php`: Manages CRUD operations for organization. -->

  
- **Middleware**
  - `AdminMiddleware.php`: Restricts access to admin-only routes.
  - `AuthMiddleware.php`: Handles user authentication for protected routes.
- **Services**
  - `ItemService.php`: Manages Item service.
- **View**
  - `Items/create.blade.php`: Manages the creation of items.
- **Routes**
  - `api.php`: API routes.

</details>

For each touched file, please refer to the version control system (Git) for the latest version and changes made.

**Packages Used**

<details>
<summary>Packages Used</summary>

Our project utilizes several packages to enhance functionality and streamline development. Here are some of the key packages used:

- `package-name`: Description of package functionality.
- `another-package`: Description of another package functionality.

</details>

**Branching Strategy**

<details>
<summary>Branching Strategy</summary>

A clear and consistent branching strategy streamlines development, release management, and collaboration within our team. We follow a branching model for our project:

- **Main**: Main branch representing the production-ready code.
- **Development**: Integration branch for ongoing development and feature integration.
- **Feature Branches**: Branches created for developing new features or enhancements.
  - Naming Convention: feature/<feature-name>
- **Release Branches**: Branches created for preparing a release.
  - Naming Convention: release/<version>
- **Hotfix Branches**: Branches created to address critical bugs in production.
  - Naming Convention: hotfix/<issue-description>

</details>

**Workflow**

<details>
<summary>Workflow</summary>

Our development workflow encompasses the following steps to manage code changes effectively:

1. **Clone the Repository**: Clone the project repository to your local development environment using Git.
2. **Create a Feature Branch**: Create a new feature branch from the develop branch for your task or feature development.
3. **Write Code**: Write clean, well-documented, and tested code following the project's coding standards and guidelines.
4. **Commit Changes**: Make small, atomic commits with clear and descriptive commit messages. Commit often to track your progress.
5. **Push Branch**: Push your feature branch to the remote repository to collaborate with other team members.
6. **Submit Pull Request**: When your feature is ready for review, submit a pull request from your feature branch to the develop branch.
7. **Code Review**: Participate in code reviews to ensure code quality, adherence to standards, and knowledge sharing among team members.
8. **Merge Changes**: After approval, merge your pull request into the develop branch. Ensure that your local branch is up-to-date before merging.
9. **Release Preparation**: When preparing for a release, create a release branch from develop and follow the release process.
10. **Deployment**: Deploy releases to the staging or production environment as needed. Merge release branches into both main and develop upon release.
11. **Bug Fixes**: Address bugs and issues reported in production by creating hotfix branches from main and following the same process as feature branches.
12. **Continuous Integration**: Set up continuous integration (CI) pipelines to automate testing, code quality checks, and deployment processes.

</details>

This workflow promotes collaboration, transparency, and code quality throughout the development lifecycle.
```
