<?php



namespace App\Http\Controllers\Api;



use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Currency;

use App\Models\Country;

use App\Models\State;

use App\Models\City;

use App\Models\Address;

use App\Service\ActivityService;



class AddressController extends Controller

{



    public function adreessCreateUpdate(Request $request){

        $auth=\Auth::user();

        $validator=validator($request->all(),[

            'user_id'=>'required|integer'

        ]);

        if ($validator->fails()) { 

            return [

                'success' => false, 

                'message' => $validator->errors()->first(),

            ];
        } else {

            // 'name', 'city', 'state', 'mobile',

            $data=[

                'house_no','country','landmark', 'address_type','street_1','street_2', 'locality', 'zip_code',

                'city_id','state_id','country_id','phone_no','fax_no'

            ];

            foreach ($data as $key => $value) {

                if(isset($request[$value]) && $request[$value]!=null && $request[$value]!=''){

                    $obj[$value]=$request[$value];

                }

                

                if($request[$value]==''){

                    $obj[$value]=null;

                }

                if($request[$value]==0){

                    $obj[$value]=0;

                }

            }

            if($request->id>0){

                try{
                  // $obj['user_id']=$user['id'];

                    $user_address=Address::where('organisation_id',$auth['active_organisation'])

                                            ->where('id',$request->id)

                                            ->first();



                    $user_address['is_shipping']=$request['is_shipping']??0;

                    $user_address['is_billing']=$request['is_billing']??0;

                    

                    $user_address->update($obj);



                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                    // Return error message in JSON if ID not found

                    return response()->json(['message' => 'Invalid Id to update '], 404);

                }

            }else{



                $obj['user_id']=$request['user_id'];



                $user_address=Address::create($obj);



                // $check=$this->deactivateSetAddress($user_address['user_id']);



                $user_address['is_shipping']=$request['is_shipping']??0;

                $user_address['is_billing']=$request['is_billing']??0;



                $user_address->update();

            }



            return response()->json(['status'=>200,'message'=>$request->id>0 ? 'Address update successfully':'address Created Successfully',

            'address'=>$user_address],200);



        }

    }


    public function addressList(Request $request){
        $validator=validator($request->all(),[

            'user_id'=>'required|integer'

        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first(),
            ];

        } else {

            $address=Address::where('user_id',$request['user_id'])

            // ->where('organisation_id',\Auth::user()['active_organisation'])

            ->get();

            $response=[

                'success'=>true,

                'address'=>$address,
                'message'=>'Address Lists'
            ];
        }
    }

    

    public function getcountry(Request $request){

        $country=Country::get();



        $response=[

            'success'=>true,

            'country'=>$country

        ];



        return response()->json($response);

    }



    public function getstate(Request $request){



        // Validate Item

        $validator=validator($request->all(),[

            'country_id'=>'required',

        ]);



        if ($validator->fails()) { 

            return [

                'success' => false, 

                'message' => $validator->errors()->first()

            ];

        } else {

            $state=State::where('country_id',$request['country_id'])->select('id','name')

                ->orderBy('name','Asc')

                ->get();



            $response=[

                'success'=>true,

                'country'=>$state

            ];



            return response()->json($response);

        }

    }



    public function getcity(Request $request){

        // Validate Item

        $validator=validator($request->all(),[

            'state_id'=>'required',

        ]);



        if ($validator->fails()) { 

            return [

                'success' => false, 

                'message' => $validator->errors()->first()

            ];

        } else {

            $city=City::where('state_id',$request['state_id'])

                ->select('id','name')->orderBy('name','Asc')

                ->get();



            $response=[

                'success'=>true,

                'country'=>$city

            ];

    

            return response()->json($response);

        }

    }



    public function getAllCurrency(Request $request){

        $currency=Currency::get();



        $response=[

            'success'=>true,

            'currency'=>$currency

        ];



        return response()->json($response);

    }





}

