<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\OrderTracking;
use App\Models\Status;
use App\Models\Order;

class DashboardController extends Controller
{
    public function dashboardCount(Request $request)
    {
        // Get all active statuses
        $statusList = Status::where('is_disabled', 0)
            ->where('is_dashboard',0)
            ->select('id', 'name','parent_id','fullurl');

        if(isset($request['parent_id']) && $request['parent_id'] !=0 && $request['parent_id'] != ''){
            $statusList=$statusList->where('parent_id','=',$request['parent_id']);
        }
        
        $statusList = $statusList->get();

        // total orders
        $totalOrders = Order::where('is_deleted', 0);

        // Get order counts grouped by status
        $orderCounts = Order::select('sub_status', \DB::raw('COUNT(*) as total'))
            ->where('is_deleted', 0);

        if(isset($request['vendor_id']) && $request['vendor_id']!=0 && $request['vendor_id']!="")
        {
            $orderCounts=$orderCounts->where('vendor_id','=',$request->vendor_id);

            $totalOrders=$totalOrders->where('vendor_id','=',$request->vendor_id);
        }
        
        if(isset($request['customer_id']) && $request['customer_id']!=0 && $request['customer_id']!="")
        {
            $orderCounts=$orderCounts->where('customer_id','=',$request->customer_id);

            $totalOrders=$totalOrders->where('customer_id','=',$request->customer_id);
        }

        $orderCounts = $orderCounts
            ->groupBy('sub_status')
            ->pluck('total', 'sub_status'); // [status_id => count]

        // Attach count to each status
        foreach ($statusList as $status) {
            $status->count = $orderCounts[$status->name] ??null;
        }

        $totalOrders = $totalOrders->count();

        // Order Tracking Activity
        $tracking=OrderTracking::with('order');

        if(isset($request['vendor_id']) && $request['vendor_id']!=0 && $request['vendor_id']!="")
        {
            $tracking=$tracking->whereHas('order', function ($query) use ($request) {
                $query->where('vendor_id','=',$request->vendor_id);
            });
        }
        
        if(isset($request['customer_id']) && $request['customer_id']!=0 && $request['customer_id']!="")
        {
            $tracking=$tracking->whereHas('order', function ($query) use ($request) {
                $query->where('customer_id','=',$request->customer_id);
            });
        }

        $tracking=$tracking->orderBy('created_at','desc')->limit(10)->get();
        

        return response()->json([
            'success' => true,
            'message' => 'Order list page Filters',
            'total_orders' => $totalOrders,
            'activity' => $tracking,
            'data' => $statusList,
        ]);
    }
}
