<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\User;
use App\Service\OrderItemService;
use App\Service\DocumentsService;
use Carbon\Carbon;
use Auth;
use App\Models\OrderTracking;
use App\Models\Status;
use App\Models\OrderItem;
use App\Service\SequenceService;
use App\Models\Document;
use App\Models\Quotation;

class OrderController extends Controller
{
    public function orderCreateUpdate(Request $request){
        // Validate Item
        $validator=validator($request->all(),[

            'order_id'=>'required'
        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {
            $user=Auth::user();

            $obj['order_id']=$request['order_id'];
            $obj['customer_id']=$user['id'];
            $obj['transaction_date']=Carbon::now()->format('Y-m-d');
            $obj['service_type']=$request['service_type'];
            $obj['service_mode']=$request['service_mode'];
            $obj['priority']=$request['priority'];
            $obj['requested_pickup_date_time']=$request['requested_pickup_date_time'];
            $obj['expected_delivery_date_time']=$request['expected_delivery_date_time'];
            $obj['preferred_carrier']=$request['preferred_carrier'];
            $obj['quotation_expiry_date']=$request['quotation_expiry_date'];
            $obj['note']=$request['note'];
            $obj['ratings']=$request['ratings']??0;
            $obj['ratings_json']=$request['ratings_json'];
            $obj['ratings_review']=$request['ratings_review'];

            $obj['state']=$request['state'];
            $obj['country']=$request['country'];
            $obj['city']=$request['city'];
            $obj['area']=$request['area'];
            $obj['pin_code']=$request['pin_code'];
            $obj['status']='Order Creation';
            $obj['sub_status']='Draft';
            $obj['status_id']=Status::where('name','Draft')->first()['id'];

            // sender
            $obj['sender_name']=$request['sender_name'];
            $obj['sender_company']=$request['sender_company'];
            $obj['sender_address_line_1']=$request['sender_address_line_1'];
            $obj['sender_address_line_2']=$request['sender_address_line_2'];
            $obj['sender_country']=$request['sender_country'];
            $obj['sender_state']=$request['sender_state'];
            $obj['sender_city']=$request['sender_city'];
            $obj['sender_pin_code']=$request['sender_pin_code'];
            $obj['sender_mobile_number']=$request['sender_mobile_number'];
            $obj['sender_email']=$request['sender_email'];
            $obj['sender_pickup_date']=$request['sender_pickup_date'];
            $obj['sender_special_instructions']=$request['sender_special_instructions'];

            // receiver
            $obj['receiver_name']=$request['receiver_name'];
            $obj['receiver_company']=$request['receiver_company'];
            $obj['receiver_address_line_1']=$request['receiver_address_line_1'];
            $obj['receiver_address_line_2']=$request['receiver_address_line_2'];
            $obj['receiver_country']=$request['receiver_country'];
            $obj['receiver_state']=$request['receiver_state'];
            $obj['receiver_city']=$request['receiver_city'];
            $obj['receiver_pin_code']=$request['receiver_pin_code'];
            $obj['receiver_mobile_number']=$request['receiver_mobile_number'];
            $obj['receiver_email']=$request['receiver_email'];
            $obj['receiver_delivery_instructions']=$request['receiver_delivery_instructions'];

            // shipment specification
            $obj['number_of_packages']=$request['number_of_packages'];
            $obj['company']=$request['company'];
            $obj['actual_weight']=$request['actual_weight'];
            $obj['dimensions']=$request['dimensions'];
            $obj['volumetric_weight']=$request['volumetric_weight'];
            $obj['chargeable_weight']=$request['chargeable_weight'];
            $obj['description_of_contents']=$request['description_of_contents'];
            $obj['declared_value']=$request['declared_value'];
            $obj['fragile']=$request['fragile'];
            $obj['perishable']=$request['perishable'];
            $obj['hazardous']=$request['hazardous'];
            $obj['insurance_required']=$request['insurance_required'];
            $obj['packaging_type']=$request['packaging_type'];
            $obj['packaging_provided_by']=$request['packaging_provided_by'];
            $obj['barcode_or_qr_code']=$request['barcode_or_qr_code'];

            $obj['signature_on_delivery']=$request['signature_on_delivery'];
            $obj['sms_updates']=$request['sms_updates'];
            $obj['email_updates']=$request['email_updates'];
            $obj['temperature_control']=$request['temperature_control'];
            $obj['special_handling']=$request['special_handling'];
            $obj['otp_verification']=$request['otp_verification'];
            $obj['return_to_origin_if_fail']=$request['return_to_origin_if_fail'];

            // service customization
            $obj['delivery_type']=$request['delivery_type'];
            $obj['vehicle_type']=$request['vehicle_type'];
            $obj['handling_requirements']=$request['handling_requirements'];
            $obj['loading']=$request['loading'];
            $obj['unloading']=$request['unloading'];
            $obj['preferred_vendor_type']=$request['preferred_vendor_type'];

            // shipment notes
            $obj['shipment_notes']=$request['shipment_notes'];
            $obj['deadline']=$request['deadline'];

            // Update Order
            if($request['id']>0){
                $order=Order::where('id','=',$request['id'])->first();

                // Delete Order Items
                OrderItem::where('order_id','=',$order->id)->delete();

                // Delete Order Documents
                Document::where('order_id','=',$order->id)->delete();

                $order->update($obj);
            }else{
                // Creating Order
                $order=Order::create($obj);

                $sequence=new SequenceService;

                //update Order_tracking
                $order_tracking=new OrderTracking;
                $order_tracking->order_id=$order->id;
                $order_tracking->status=$order->status??null;
                $order_tracking->status_id=$order->status_id??0;
                $order_tracking->sub_status=$order->status??0;
                $order_tracking->save();

                // Update Sequence Number
                $sequence->updateSequence('order');
            }

            // item specification   
            $itemservice=new OrderItemService();
            $itemservice->saveItems($request,$order);

            // Save Documents
            $documentservice=new DocumentsService();
            $documentservice->documentCreateUpdate($request,$order);

            // Return Response
            return [
                'success' => true, 
                'message' => $request['id']>0 ? 'Order Updated Successfully' : 'Order Created Successfully',
                'data' => $order
            ];

        }

    }

    // List Of Order with filters
    public function orderList(Request $request)
    {
        $user=Auth::user();

        $order=Order::where('is_deleted',0)->with('customer','vendor','order_tracking');

        if(isset($request['status']) && $request['status']!="" && $request['status']!=null){
            $order->where('status',$request['status']);
        }

        if(isset($request['sub_status']) && $request['sub_status']!="" && $request['sub_status']!=null){
            $order->where('sub_status',$request['sub_status']);
        }

        if(isset($request['vendor_id']) && $request['vendor_id']!=0 && $request['vendor_id']!="")
        {
            $order->where('vendor_id','=',$request->vendor_id);
        }

        if(isset($request['user_id']) && $request['user_id']!=0 && $request['user_id']!="")
        {
            $order->where('enteredbyid','=',$request->user_id);
        }

        if ($user['id']==$request['user_id']) {
            $order->where('enteredbyid','=',$user['id']);
        }
        

        if(isset($request['service_type']) && $request['service_type']!="" && $request['service_type']!=null)
        {
            $order->where('service_type','=',$request->service_type);
        }

        if(isset($request['priority']) && $request['priority']!="" && $request['priority']!=null)
        {
            $order->where('priority','=',$request->priority);
        }

    
        if(isset($request['status_id']) && $request['status_id']!="" && $request['status_id']!=null)
        {
            $order->where('status_id','=',$request->status_id);
        }

        // Date Filters
        if(isset($request['start_date']) && $request['start_date']!="" && $request['start_date']!=null && isset($request['end_date']) && $request['end_date']!="" && $request['end_date']!=null)
        {
            $order->whereBetween('transaction_date',[$request->start_date,$request->end_date]);
        }

        // transaction date
        if(isset($request['transaction_date']) && $request['transaction_date']!="" && $request['transaction_date']!=null)
        {
            $order->where('transaction_date','=',$request->transaction_date);
        }

        // Search
        if($request['search']!=null && $request['search']!=''){

            $order = $order->where(function ($query) use ($request) {

                $query->where('order_id', 'LIKE', '%' . $request['search'] . '%')

                ->orWhere('service_type', 'LIKE', '%' . $request['search'] . '%')

                ->orWhere('preferred_carrier', 'LIKE', '%' . $request['search'] . '%')

                ->orWhereHas('vendor', function ($query) use ($request) {
                    $query->where('display_name', 'LIKE', '%' . $request['search'] . '%');
                });

            });
        }

        $count=$order->count();

        $order=$order->orderBy('id','desc')
        ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??50)
        ->get();

        return [
            'success' => true, 
            'message' => 'Orders List',
            'data' => $order,
            'count' => $count
        ];
    }

    // List Of Order with filters
    public function orderListVendor(Request $request)
    {
        $user=Auth::user();

        $order=Order::where('is_deleted',0)->with('customer','vendor','order_tracking')
            ->where(function ($q) use ($user) {
                $q->where('is_requested', 1)
                ->orWhere(function ($q2) use ($user) {
                    $q2->where('is_requested', 0)
                        ->where('enteredbyid', $user['id']);
                });
            });

        if(isset($request['status']) && $request['status']!="" && $request['status']!=null){
            $order->where('status',$request['status']);
        }

        if(isset($request['sub_status']) && $request['sub_status']!="" && $request['sub_status']!=null){
            $order->where('sub_status',$request['sub_status']);
        }

        if(isset($request['vendor_id']) && $request['vendor_id']!=0 && $request['vendor_id']!="")
        {
            $order->where('vendor_id','=',$request->vendor_id);
        }

        if(isset($request['service_type']) && $request['service_type']!="" && $request['service_type']!=null)
        {
            $order->where('service_type','=',$request->service_type);
        }

        if(isset($request['priority']) && $request['priority']!="" && $request['priority']!=null)
        {
            $order->where('priority','=',$request->priority);
        }

    
        if(isset($request['status_id']) && $request['status_id']!="" && $request['status_id']!=null)
        {
            $order->where('status_id','=',$request->status_id);
        }

        // Date Filters
        if(isset($request['start_date']) && $request['start_date']!="" && $request['start_date']!=null && isset($request['end_date']) && $request['end_date']!="" && $request['end_date']!=null)
        {
            $order->whereBetween('transaction_date',[$request->start_date,$request->end_date]);
        }

        // transaction date
        if(isset($request['transaction_date']) && $request['transaction_date']!="" && $request['transaction_date']!=null)
        {
            $order->where('transaction_date','=',$request->transaction_date);
        }

        // Search
        if($request['search']!=null && $request['search']!=''){

            $order = $order->where(function ($query) use ($request) {

                $query->where('order_id', 'LIKE', '%' . $request['search'] . '%')

                ->orWhere('service_type', 'LIKE', '%' . $request['search'] . '%')

                ->orWhere('preferred_carrier', 'LIKE', '%' . $request['search'] . '%')

                ->orWhereHas('vendor', function ($query) use ($request) {
                    $query->where('display_name', 'LIKE', '%' . $request['search'] . '%');
                });

            });
        }

        $count=$order->count();

        $order=$order->orderBy('id','desc')
        ->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??50)
        ->get();

        return [
            'success' => true, 
            'message' => 'Orders List',
            'data' => $order,
            'count' => $count
        ];
    }

    // Order Details
    public function orderDetails(Request $request){
         $validator=validator($request->all(),[

            'order_id'=>'required'
        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {

            $order=Order::where('id','=',$request->order_id)
                ->with('items','items.item','items.item.category','items.item.sub_category','documents','vendor','customer',
                'customer.address','customer.address.city:id,name','customer.address.country:id,name',
                'customer.address.state:id,name','order_tracking')
                ->first();

            return [
                'success' => true, 
                'message' => 'Order Details',
                'data' => $order
            ];

        }
    }

    //order status
    public function orderStatus(Request $request){

         // Validate Item
        $validator=validator($request->all(),[
            'order_id'=>'required'
        ]);

        if ($validator->fails()) { 

            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {
            $order=Order::where('id','=',$request->order_id)->first();

            //update Order_tracking
            $order_tracking=new OrderTracking;
            $order_tracking->order_id=$request->order_id;
            $order_tracking->status=$request->status??null;
            $order_tracking->status_id=$request->status_id??0;
            $order_tracking->comments=$request->comments;
            $order_tracking->location=$request->location;
            $order_tracking->delivery_time=$request->delivery_time;
            $order_tracking->sub_status=$request->sub_status??0;
            $order_tracking->address_from=$request->address_from??0;
            $order_tracking->address_to=$request->address_to??0;
            $order_tracking->save();

            // Quotation Requested id set
            if($request['sub_status']== 'Quotation Requested'){

                $order->status_id=Status::where('name','Like','%Requested%')->first()['id'];
                $order->is_requested=1;
            }

            // Deliverd
            if($request['sub_status']== 'Delivered'){

                $order->is_delivered=1;
            }

            // Return
            if (stripos($request['sub_status'], 'return') !== false) {
                $order->is_returned=1;
            }

            // Cancelled
            if (stripos($request['sub_status'], 'cancel') !== false || stripos($request['status'], 'cancle') !== false) {
                $order->is_cancelled=1;
            }

            $order->status=$request->status;
            $order->sub_status=$request->sub_status;
            $order->status_id=$request->status_id;
            $order->save();

            return [
                'success' => true, 
                'data' => $order,
                'message' => 'Order Status Updated Successfully'
            ];
        }
    }

    public function orderRatings(Request $request)
    {
        // $validator = validator($request->all(), [
        //     'vendor_id' => 'required',
        // ]);

        // if ($validator->fails()) {
        //     return response()->json([
        //         'success' => false,
        //         'message' => $validator->errors()->first()
        //     ]);
        // }

        // Pagination defaults
        $perPage = $request->noofrec ?? 50;
        $currentPage = $request->currentpage ?? 1;
        $offset = ($currentPage - 1) * $perPage;

        // Base query
        $query = Order::with('customer','vendor')
            ->where('is_delivered', 1)
            ->where('is_deleted', 0)
            ->where('is_cancelled', 0);

        if(isset($request['vendor_id']) && $request['vendor_id'] !=0 && $request['vendor_id'] != ''){
            $query=$query->where('vendor_id','=',$request['vendor_id']);
        }

        if(isset($request['customer_id']) && $request['customer_id'] !=0 && $request['customer_id'] != ''){
            $query=$query->where('customer_id','=',$request['customer_id']);
        }

        // Total count (before pagination)
        $count = $query->count();

        // Paginated data
        $orders = $query
            ->orderBy('id', 'desc')
            ->skip($offset)
            ->take($perPage)
            ->get();

        return response()->json([
            'success' => true,
            'message' => 'Order Ratings',
            'count' => $count,
            'data' => $orders
        ]);
    }


    // Order list filters according to status
    public function orderFilters(Request $request)
    {
        // Get all active statuses
        $statusList = Status::where('is_disabled', 0)
            ->select('id', 'name','parent_id','fullurl');

        if(isset($request['parent_id']) && $request['parent_id'] !=0 && $request['parent_id'] != ''){
            $statusList=$statusList->where('parent_id','=',$request['parent_id']);
        }
        
        $statusList = $statusList->get();

        // Get order counts grouped by status
        $orderCounts = Order::select('sub_status', \DB::raw('COUNT(*) as total'))
            ->where('is_deleted', 0);

        if(isset($request['vendor_id']) && $request['vendor_id']!=0 && $request['vendor_id']!="")
        {
            $orderCounts=$orderCounts->where('vendor_id','=',$request->vendor_id);
        }
        
        if(isset($request['customer_id']) && $request['customer_id']!=0 && $request['customer_id']!="")
        {
            $orderCounts=$orderCounts->where('customer_id','=',$request->customer_id);
        }

        $orderCounts = $orderCounts
            ->groupBy('sub_status')
            ->pluck('total', 'sub_status'); // [status_id => count]

        // Attach count to each status
        foreach ($statusList as $status) {
            $status->count = $orderCounts[$status->name] ??null;
        }

        return response()->json([
            'success' => true,
            'message' => 'Order list page Filters',
            'data' => $statusList,
            'requested_count'=>Order::where('is_requested',1)
                ->where('sub_status','Like','%Requested%')
                ->count()
        ]);
    }

    // Update vendor Quotation in order
    public function updateVendor(Request $request)
    {
        $validator = validator($request->all(), [
            'order_id' => 'required',
            'vendor_id' => 'required',
            'quotation_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);
        }

        $order = Order::find($request->order_id);

        if ($order) {

            //update Order_tracking
            $order_tracking=new OrderTracking;
            $order_tracking->order_id=$order->id;
            $order_tracking->status='Order Creation';
            $order_tracking->status_id=Status::where('name','Like','%Confirmed%')->first()['id'];
            $order_tracking->comments='Order Confirmed by the Vendor';
            $order_tracking->sub_status='Order Confirmed';
            $order_tracking->save();

            // Update Status on Order
            $order->vendor_id = $request->vendor_id;
            $order->status = 'Order Creation';
            $order->sub_status = 'Order Confirmed';
            $order->status_id=$order_tracking->status_id;
            $order->save();

            // Update Quotation status
            $quotation = Quotation::find($request->quotation_id);
            $quotation->status = 3;   // order Confirmed
            $quotation->save();

            return response()->json([
                'success' => true,
                'message' => 'Order Confirmed Successfully',
                'data' => $order
            ]);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'Order Not Found'
            ]);
        }
    }

    // Update Ratings in order
    public function updateRatings(Request $request)
    {
        $validator = validator($request->all(), [
            'order_id' => 'required',
            'ratings' => 'required',
            'ratings_json' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first()
            ]);
        }

        $order = Order::find($request->order_id);

        if ($order) {
            $order->ratings = $request->ratings;
            $order->ratings_json = $request->ratings_json;
            $order->ratings_review = $request->ratings_review;
            $order->save();

            return response()->json([
                'success' => true,
                'message' => 'Ratings Updated Successfully',
                'data' => $order
            ]);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'Order Not Found'
            ]);
        }
    }

}

