<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use App\Models\SequenceFormat;
use Log;

class SequenceFormatController extends Controller
{
    public function createUpdateSequence(Request $request){
          // Validate Item
          $validator=validator($request->all(),[
            'prefix'=>'required',
            'delimiter'=>'required',
            'sequence_number'=>'required',
            'module'=>'required',
            'sequence_type'=>'required',      //2 for manual and 1 for auto-generate
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {
           
            //Modules:-
            //quotation , sale_order , delivery_challan , invoice , credit_note, payment_receipt,
            // purchase_order, bill , debit_note , payment_made ,expenses , grn ,accounts , journal
            //dsr

            $obj['prefix']=$request['prefix'];
            $obj['delimiter']=$request['delimiter'];
            $obj['padded_digits']=$request['padded_digits']??0;
            $obj['start_sequence']=$request['sequence_number']??0;
            $obj['sequence_number']=$request['sequence_number'];
            $obj['module']=$request['module'];
            $obj['notes']=$request['notes'];
            $obj['sequence_type']=$request['sequence_type']??1;

            $check=SequenceFormat::where('module',$request['module'])
                ->where('rolledback',0)
                ->first();

            if($request['id']>0){

                $sequenceFormat=SequenceFormat::find($request['id']);
                $sequenceFormat->update($obj);

            }else{

                if($check!=null){
                    return [
                        'success' => false,
                        'message' => 'Sequence already exist for this module'
                    ];
                    
                }else{
                    
                    $sequenceFormat=SequenceFormat::create($obj);
                }
                
            }
            
            $sequenceFormat->save();
            $response= [
                'success' => true,
                'message' => 'Sequence Format saved successfully',
                'sequence'=>$sequenceFormat
            ];

            return response()->json($response, 200);
        }
    }

    public function fetchSequence(Request $request){

        $sequence=SequenceFormat::where('rolledback',0);

        if(isset($request['module']) && $request['module']!=null){
            $sequence=$sequence->where('module',$request['module']);
        }

        $sequence=$sequence->get();
        
        $response=[
            'success' => true,
            'message' => 'Sequence fetched successfully',
            'sequence'=>$sequence
        ];

        return response()->json($response);
    }

    public function delete(Request $request){
         // Validate Item
         $validator=validator($request->all(),[
            'id'=>'required',     //2 for manual and 1 for auto-generate
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            try{
                 $sequence=SequenceFormat::findOrFail($request['id']);

                 $sequence['rolledback']=1;

                 $sequence->update();
            
            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                        // Return error message in JSON if ID not found
                return response()->json(['message' => 'Invalid Id to update '], 404);
            }
        }
    }

}
