<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;

class TicketController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function feedbackView(Request $request)
    {
        $user=Auth::user();

        $datas = Feedback::where('organisation_id',$user['active_organisation'])
            ->orderBy('id', 'DESC')->get();

        $users = User::where('organisation_id',$user['active_organisation'])->get();


        // return view('manage_tickets.feedbacks', compact('datas', 'users'));
        $response=[
            'success'=>true,
            'message'=>'FeedBack view fetched',
            'data'=>$datas,
            'users'=>$users
        ];

        return response()->json($response);
    }

    public function ticketView(Request $request)
    {
        $datas = Ticket::where('organisation_id',$user['active_organisation'])
            ->orderBy('id', 'DESC')->get();

        $users = User::where('organisation_id',$user['active_organisation'])->get();

        $response=[
            'success'=>true,
            'message'=>'FeedBack view fetched',
            'data'=>$datas,
            'users'=>$users
        ];

        return response()->json($data, 200, $headers);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

        public function chat()
        {
            return view('ticket.chat');
        }

    public function createTicket()
    {
        return view('ticket.create');
    }

    public function createFeedback()
    {
        return view('feedback.create');
    }

    public function ticket_details($id)
    {
        $ticket = Ticket::find($id);
        return view('manage_tickets.ticket_details', compact('ticket'));
    }

    public function feedback_details($id)
    {
        $feedback = Feedback::find($id);
        return view('manage_tickets.feedback_details', compact('feedback'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeFeedback(Request $request)
    {
        $user = Auth::user();

        $data = new Feedback;
        $data->user_id = $user->id;
        $data->issue_type = $request->input("issue_type");
        $data->module = $request->input("module");
        $data->page_url = $request->input("page_url");
        $data->audio_video_url = $request->input("audio_video_url");
        $data->priority = $request->input("priority");
        if ($request->hasFile('screenshots')) {
            $screenshots = $request->file('screenshots');
            $screenshotsData = [];
        
            foreach ($screenshots as $screenshot) {
                $filename = time() . '_' . $screenshot->getClientOriginalName();
                $path = public_path('uploads');
                $screenshot->move($path, $filename);
        
                $screenshotsData[] = $filename;
            }
        
            $data->screenshots = json_encode($screenshotsData);
        }
        $data->comments = $request->input("comments");
        $data->save();

        session()->flash('success', 'Feedback created successfully.');
        return Redirect::back();
    }

    public function storeTicket(Request $request)
    {
        $user = Auth::user();

        $data = new Ticket;
        $data->user_id = $user->id;
        $data->issue_type = $request->input("issue_type");
        $data->module = $request->input("module");
        $data->page_url = $request->input("page_url");
        $data->audio_video_url = $request->input("audio_video_url");
        $data->priority = $request->input("priority");
        if ($request->hasFile('screenshots')) {
            $screenshots = $request->file('screenshots');
            $screenshotsData = [];
        
            foreach ($screenshots as $screenshot) {
                $filename = time() . '_' . $screenshot->getClientOriginalName();
                $path = public_path('uploads');
                $screenshot->move($path, $filename);
        
                $screenshotsData[] = $filename;
            }
        
            $data->screenshots = json_encode($screenshotsData);
        }
        $data->comments = $request->input("comments");
        $data->save();

        session()->flash('success', 'Ticket created successfully.');
        return Redirect::back();
    }
    
    public function ticket_status(Request $request)
    {
        $id = $request->input("ticket_id");
        $data = Ticket::find($id);
        $data->status = $request->input("status");
        $data->save();
        
        session()->flash('success', 'Status updated successfully.');

        return Redirect::back();
    }
    
    public function feedback_status(Request $request)
    {
        $id = $request->input("feedback_id");
        $data = Feedback::find($id);
        $data->status = $request->input("status");
        $data->save();
        
        session()->flash('success', 'Status updated successfully.');

        // return redirect()->route('feedback.view');

        return Redirect::back();
    }
    

    
    public function destroy($id)
    {
        //
        $cat = DailyDeals::find($id);
        $cat->delete();
        session()->flash('success', 'You\'ve Deleted Expense Account successfully.');
        
        return Redirect::back();
    }

}

