<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Address;
use App\Models\BankDetails;
use App\Models\Document;
use App\Service\ProfileService;
use App\Service\BankService;
use App\Service\DocumentsService;
use Auth;
use App\Service\AddressService;
use Log;
use Hash;
use Validator;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\UserImport;
use App\Service\ActivityService;
use App\Models\SequenceFormat;
use App\Service\SequenceService;


class UserController extends Controller

{

    public function createUpdateUser(Request $request){

        $auth=Auth::user();

        $profileservice=new ProfileService;

        $profile=[];

        // Validate Item
        $validator=validator($request->all(),[
            'display_name'=>'required|string'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];

        } else {

            // ===== Document No Unique Check =====
            if ($request->has('documents') && is_array($request->documents)) {
                foreach ($request->documents as $doc) {
                    if (!empty($doc['document_no'])) {
                        $exists = Document::where('document_no', $doc['document_no'])
                            ->when($request['id'] > 0, function($q) use ($request) {
                                $q->where('user_id', '!=', $request['id']); // exclude current user in update
                            })
                            ->exists();

                        if ($exists) {
                            return response()->json([
                                'success' => false,
                                'message' => "Document number {$doc['document_no']} already exists."
                            ], 200);
                        }
                    }
                }
            }

            // ===== Bank Account No Unique Check =====
            if ($request->has('bank_details') && is_array($request->bank_details)) {
                foreach ($request->bank_details as $bank) {
                    if (!empty($bank['account_no'])) {
                        $exists = BankDetails::where('account_no', $bank['account_no'])
                            ->when($request['id'] > 0, function($q) use ($request) {
                                $q->where('user_id', '!=', $request['id']);
                            })
                            ->exists();

                        if ($exists) {
                            return response()->json([
                                'success' => false,
                                'message' => "Bank account number {$bank['account_no']} already exists."
                            ], 200);
                        }
                    }
                }
            }


            if($request['id']>0){

                try{

                    $user=User::findOrFail($request['id']);

                    if(isset($request['password'])){

                        $user['password']=Hash::make($request['password']);
                        $user['c_password']=$request['password'];
                    } 

                    if($request['is_customer']==1){
                        $user['is_customer']=$request['is_customer'];
                    }

                    if($request['is_user']==1){
                        $user['is_user']=$request['is_user'];
                    }

                    if($request['is_vendor']==1){
                        $user['is_vendor']=$request['is_vendor'];
                    }

                    if(isset($request['email'])){

                        $user['email']=$request['email'];
                        //$user['vpass']=Hash::make($request['password']);
                    }

                    $user['status']=0;

                    $profile=$profileservice->createupdateProfile($user,$request);

                    $profile->update();


                    // Delete Existing Address
                    Address::where('user_id',$request['id'])->delete();

                    //Deleting Existing Bank Details
                    BankDetails::where('user_id',$request['id'])->delete(); // delete bank details

                    //Deleting Existing Document Details
                    Document::where('user_id',$request['id'])->delete(); // delete bank details

                    // --------------------------------------------------------------------------------------
                    //createing new Address
                    $addressess=new AddressService;
                    $addressess->adreessCreateUpdate($request,$user);

                    //createing new Bank Details
                    $bank_service=new BankService;
                    $bank_service->bankServiceCreateUpdate($request,$user); // create bank details

                    //createing new Document Details
                    $doc_service=new DocumentsService;
                    $doc_service->documentCreateUpdateUser($request,$user); // create Documents details

                } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                    // Return error message in JSON if ID not found
                    return response()->json(['success' => false,'message' => 'Invalid Id to update '], 200);

                }

            }else{

                // Update Sequence Number
                $sequence=new SequenceService;
                

                if($request['email']!=null && isset($request['email']) && $request['email'!='']){

                    $checkemail=User::where('email',$request['email'])
                        ->select('id','name','email')
                        ->first();

                    if($checkemail !=null){

                        $response=[
                            'message'=>"Email id already exist",
                            'success'=>false,
                            'vendor'=>$checkemail
                        ];

                        return response()->json($response);
                    }
                }
        
                $obj['first_name']=$request['first_name'];
                $obj['display_name']=$request['display_name'];

                $user=User::create($obj);

                // Apps Setting The Default Organisation
                // if($request['app_permission']!=null && isset($request['app_permission'])){
                //     $user['app_permission']=$request['app_permission'];
                // }else{
                //     $user['app_permission']='"{\"accounting\":1,\"hrms\":1,\"pay_roll\":1,\"manufacturing\":1,\"logistics\":1,\"workshop\":1,\"cms\":1,\"container_owner\":1,\"tms\":1,\"legal\":0,\"mice_dsr\":0,\"fleet_tracking\":0}"';
                // }

                if(isset($request['password'])){

                    $user['password']=Hash::make($request['password']);
                    $user['c_password']=$request['password'];

                } 

                if ($request->input('is_customer') == 1) {
                    $user['is_customer'] = 1;
                    $sequence->updateSequence('customer');
                }

                if ($request->input('is_vendor') == 1) {
                    $user['is_vendor'] = 1;

                    $sequence->updateSequence('vendor');
                }
                if ($request->input('is_employee') == 1) {
                    $user['is_employee'] = 1;
                }
                if ($request->input('is_user') == 1) {
                    $user['is_user'] = 1;
                }

                if(isset($request['email'])){
                    $user['email']=$request['email'];
                }

                $profile=$profileservice->createupdateProfile($user,$request);

                $profile->update();

                $addressess=new AddressService;
                $addressess->adreessCreateUpdate($request,$user);

                //createing new Bank Details
                $bank_service=new BankService;
                $bank_service->bankServiceCreateUpdate($request,$user); // create bank details
                
                //createing new Document Details
                $doc_service=new DocumentsService;
                $doc_service->documentCreateUpdateUser($request,$user); // create Documents details

            }   
            $response=[
                'message'=>$request['id']>0? "Record Updated Successfully":"Record Created Successfully",
                'success'=>true
            ];

            return response()->json($response);

        }

    }

    // Getting All the users
    public function fetchuser(Request $request){

        $user=Auth::user();

        if($user!=null){

            $userlist=User::where('is_disabled',0)

                ->with('billing_address','shipping_address','address',
                    'bank_details');

                // ->where('organisation_id',$user['active_organisation']);


            $userlist=$this->fetchuserbyquery($userlist,$request);

            $count=$userlist->count();
                                                                                                    
            if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
                
                $sort_order=$request['sort_order']==1?'asc':'desc';

                $userlist = $userlist->orderBy($request['sort_by'],$sort_order);

            }else{
                $userlist = $userlist->orderBy('id','desc');
            }

            $userlist = $userlist->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??100)
                ->get();

            
                 // Get all active , in active and draft counts
            $draft_count=User::where('is_disabled',0)->where('status',0);
            $in_active_count=User::where('is_disabled',0)->where('status',2);
            $active_count=User::where('is_disabled',0)->where('status',1);
            $suspended_count=User::where('is_disabled',0)->where('status',3);
            $all_count=User::where('is_disabled',0);

            if($request['is_user']!=null && $request['is_user']==1){

                $draft_count=$draft_count->where('is_user',1);
                $in_active_count=$in_active_count->where('is_user',1);
                $active_count=$active_count->where('is_user',1);
                $all_count=$all_count->where('is_user',1);
                $suspended_count=$suspended_count->where('is_user',1);
            }       

            if($request['is_customer']!=null && $request['is_customer']==1){

                $draft_count=$draft_count->where('is_customer',1);
                $in_active_count=$in_active_count->where('is_customer',1);
                $active_count=$active_count->where('is_customer',1);
                $all_count=$all_count->where('is_customer',1);
                $suspended_count=$suspended_count->where('is_customer',1);
            }       
            
            if($request['is_vendor']!=null && $request['is_vendor']==1){
                $draft_count=$draft_count->where('is_vendor',1);
                $in_active_count=$in_active_count->where('is_vendor',1);
                $active_count=$active_count->where('is_vendor',1);
                $all_count=$all_count->where('is_vendor',1);
                $suspended_count=$suspended_count->where('is_vendor',1);
            }


            $draft_count=$draft_count->count();
            $in_active_count=$in_active_count->count();
            $active_count=$active_count->count();
            $all_count=$all_count->count();
            $suspended_count=$suspended_count->count();
            
            $response=[
                'count'=>$count,
                'message'=>'Successful',
                'all_count'=>$all_count,
                'draft_count'=>$draft_count,
                'in_active_count'=>$in_active_count,
                'active_count'=>$active_count,
                'suspended_count'=>$suspended_count,
                'user'=>$userlist,
            ];

        } else {

            $response=[
                'user'=>$userlist,
                'count'=>$count,
                'message'=>'Invalid User'
            ];

        }

        return response()->json($response);

    }

    // Filter Users
    public function fetchuserbyquery($userlist,$request){

        if(isset($request['is_customer']) && $request['is_customer']!=0){

            $userlist=$userlist->where('is_customer',$request['is_customer']);

        }

        if(isset($request['is_vendor']) && $request['is_vendor']!=0){

            $userlist=$userlist->where('is_vendor',$request['is_vendor']);

        }

        if(isset($request['is_user']) && $request['is_user']!=0){

            $userlist=$userlist->where('is_user',$request['is_user']);

        }
        if(isset($request['is_admin']) && $request['is_admin']!=0){

            $userlist=$userlist->where('is_admin',$request['is_admin']);

        }

        if(isset($request['logistic_provider_id']) && $request['logistic_provider_id']>0){

            $userlist=$userlist->where('logistic_provider_id',$request['logistic_provider_id']);

        }
        if(isset($request['module_type']) && $request['module_type']>0){

            $userlist=$userlist->where('module_type',$request['module_type']);

        }
        if(isset($request['company_type']) && $request['company_type']>0){

            $userlist=$userlist->where('company_type',$request['company_type']);

        }

        if(isset($request['is_employee']) && $request['is_employee']!=0){

            $userlist=$userlist->where('is_employee',$request['is_employee']);

        }
        if(isset($request['is_driver']) && $request['is_driver']!=0){

            $userlist=$userlist->where('is_driver',$request['is_driver']);

        }
        if(isset($request['is_logistics']) && $request['is_logistics']!=0){

            $userlist=$userlist->where('is_logistics',$request['is_logistics']);

        }
        if(isset($request['is_container_owner']) && $request['is_container_owner']!=0){

            $userlist=$userlist->where('is_container_owner',$request['is_container_owner']);

        }

        if(isset($request['employee_user_type']) && $request['employee_user_type']!=0){

            $userlist=$userlist->where('employee_user_type',$request['employee_user_type']);

        }

        if(isset($request['search']) && $request['search']!='') {

            $keyword = "%".$request['search']."%";
        
            $userlist = $userlist->whereRaw(" (first_name like ? or last_name like ? or name like ? or company_name like ? or email like ? or mobile_no like ? or work_phone like ? or customer_type like ? or display_name like ?  or display_name like ? or company_type like ?) ", 
            array($keyword , $keyword ,$keyword , $keyword , $keyword ,$keyword,$keyword,$keyword,$keyword ,$keyword,$keyword));
        
        }

        if($request['active']!='' && isset($request['active'])){
            $userlist=$userlist->where('active',$request['active']);
        }

        if($request['status']!='' && isset($request['status'])){
            $userlist=$userlist->where('status',$request['status']);
        }

        if($request['customer_type']!='' && isset($request['customer_type'])){

            $userlist=$userlist->where('customer_type',$request['customer_type']);

        }

        if($request['overdue']!='' && isset($request['overdue']) && $request['overdue']!=0){

            $userlist=$userlist->where('balance','<>',0);

        }
        // get custom_date data by transaction_date

        if ($request['custom_date']!='' && isset($request['custom_date'])) {

            $customDate = $request->custom_date;

            $userlist = $userlist->whereDate('created_at', $customDate);

        }

        // get last modified data by updated_at

        if ($request['updated_at']!='' && isset($request['updated_at'])) {

            $userlist=$userlist->orderBy('updated_at');

        }

        // get fromDate toDate data by created_at

        if ($request['fromDate']!='' && isset($request['toDate'])) {

            $fromDate = $request->fromDate;

            $toDate = $request->toDate;

            // 'fromDate' and 'toDate'

            $userlist = $userlist->whereBetween('created_at', [$fromDate, $toDate]);

        }

        return $userlist;

    }

    // Updating a column in User Table
    public function userupdatefield(Request $request){

        $user=Auth::user();

        if($user!=null){

            $profile=User::where('id',$request['userid'])->first();

            $profile[$request['column']]=$request['value'];

            $profile->update();

        }

        return response()->json(true);

    }


    public function uploadimage(Request $request){

        $uploadservice=new UploadService;

        $user=$uploadservice->upload($request);

        return $user;

    }


    public function userscount(Request $request){

        $usercount=User::where('is_disabled',0)->where('isuser',1)->count();

        $membercount=User::where('is_disabled',0)->where('ismember',1)->count();

        $response=[

            'usercount'=>$usercount,

            'membercount'=>$membercount

        ];

        return response()->json($response);

    }


    // Details of the User /Customer /Vendor
    public function getuserdetails(Request $request){

        $response=[];

        $auth=Auth::user();

        // Validate Item
        $validator=validator($request->all(),[

            'user_id'=>'required'

        ]);

        if ($validator->fails()) { 

            return [

                'success' => false, 

                'message' => $validator->errors()->first()

            ];

        } else {

            try{

            $user=User::with('address','bank_details',
                    'documents')
                // ->where('organisation_id',$auth['active_organisation'])

                ->findOrFail($request['user_id']);

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found

                return response()->json(['success'=>false,'message' => 'Invalid Id found'], 404);

            }

            $response=[

                'success'=>true,

                'message'=>'User Details Retrieved Successfully.',

                'user'=>$user

            ];

            return response()->json($response);

        }

    }

    public function userImport(Request $request){

        // Validate Item

        $validator=validator($request->all(),[

            'file' => 'required|file',

            'user_type'=>'required'

        ]);



        if ($validator->fails()) { 

            return [

                'success' => false, 

                'message' => $validator->errors()->first()

            ];

        } else {

            $file = $request->file('file');



            Excel::import(new UserImport, $file);



            if($request['user_type']=='customer'){

                // Creating Activities

                $activity=new ActivityService;

                $activity->activityCreateUpdate('Customer',0,'Imported');



                 // return redirect()->back()->with('success', 'Item imported successfully!');

                $response=[

                    'success'=>true,

                    'message'=>'Customers Excel Imported Successfully'

                ];

            } 



            if($request['user_type']=='vendor'){

                // Creating Activities

                $activity=new ActivityService;

                $activity->activityCreateUpdate('Vendor',0,'Imported');



                 // return redirect()->back()->with('success', 'Item imported successfully!');

                $response=[

                    'success'=>true,

                    'message'=>'Vendors Excel Imported Successfully'

                ];

            }



            return response()->json($response);

        }

    }

    public function status(Request $request){

        $auth=Auth::user();

         // Validate Item
         $validator=validator($request->all(),[
            'user_id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            try {

                $user=User::findOrFail($request['user_id']);

                if(isset($request['active'])){
                    $user['active']=$request['active'];
                }

                if(isset($request['status'])){
                    $user['status']=$request['status'];
                }
                // $user['status']=$request['status']??0;

                $user->update();

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found

                return response()->json(['message' => 'Invalid Id found'], 404);

            }

            $response=[

                'success'=>true,

                'message'=>'Status Updated successfully.',

                'user'=>$user

            ];


            return response()->json($response);
        }
    }

    public function delete(Request $request){

        $auth=Auth::user();

         // Validate Item
         $validator=validator($request->all(),[
            'user_id'=>'required'
        ]);

        if ($validator->fails()) { 
            return [
                'success' => false, 
                'message' => $validator->errors()->first()
            ];
        } else {

            try {

                $user=User::where('id',$request['user_id'])

                    ->where('organisation_id',$auth['active_organisation'])
                    ->first();

                $user['is_disabled']=1;

                $user->update();

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found

                return response()->json(['message' => 'Invalid Id found'], 404);

            }

            $response=[

                'success'=>true,

                'message'=>'Deleted successfully.'

                // 'user'=>$user

            ];


            return response()->json($response);
        }
    }

    // Update Employee App Permissions like Accounting, HRMS etc.
    public function updateAppPermission(Request $request){
        $user=Auth::user();

        // Validate Item
        $validator=validator($request->all(),[
           'user_id'=>'required',
           'app_permission' => 'required|string'
       ]);

       if ($validator->fails()) { 
           return [
               'success' => false, 
               'message' => $validator->errors()->first()
           ];
       } else {

           try {

                $owner=User::where('id',$user['id'])->first();

                // Only Admin can Update Permission
                if($owner['is_admin']==1){

                    $emp=User::findOrFail($request['user_id']);
                    $emp['app_permission']=$request['app_permission'];
                    $emp->update();

                } else {

                    $response=[
                        'success'=>false,
                        'message'=>'Only Admin can give Permission'
                        // 'user'=>$user
                    ];
        
                    return response()->json($response);
                }  

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found
                return response()->json(['message' => 'Invalid Id found'], 404);
            }

            $response=[
                'success'=>true,
                'message'=>'App Permission Updated successfully.',
                'user'=>$emp
            ];

            return response()->json($response);
        }
    }

    //Delete Family Member from the family_ids column
    public function deleteFamilyMember(Request $request){

        $user=Auth::user();

        // Validate Item
        $validator=validator($request->all(),[
           'user_id'=>'required'
       ]);

       if ($validator->fails()) { 
           return [
               'success' => false, 
               'message' => $validator->errors()->first()
           ];
       } else {

           try {

                $emp = User::findOrFail($request['user_id']);
                  // Convert family_ids string to array

                if(isset($request['family_id']) && $request['family_id']>0){
                    $ids = array_filter(explode(',', $emp->family_ids));

                    // Remove the given family_id
                    $ids = array_filter($ids, function ($id) use ($request) {
                        return $id != $request['family_id'];
                    }); 

                    // Rebuild the string without trailing commas
                    $emp->family_ids = implode(',', $ids);

                    $emp->save();
                }

                if(isset($request['employee_id']) && $request['employee_id']>0){
                    $ids = array_filter(explode(',', $emp->employee_ids));

                    // Remove the given family_id
                    $ids = array_filter($ids, function ($id) use ($request) {
                        return $id != $request['employee_id'];
                    }); 

                    // Rebuild the string without trailing commas
                    $emp->employee_ids = implode(',', $ids);

                    $emp->save();
                }

                

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id found'], 200);
            }

            $response=[
                'success'=>true,
                'message'=>'Family/Employee Member Detached successfully.',
                'user'=>$emp
            ];

            return response()->json($response);
        }
    }

    //get family members
    public function getFamilyMembers(Request $request){

        $user=Auth::user();

        // Validate Item
        $validator=validator($request->all(),[
           'user_id'=>'required'
       ]);

       if ($validator->fails()) { 
           return [
               'success' => false, 
               'message' => $validator->errors()->first()
           ];
       } else {

           try {

                $emp = User::findOrFail($request['user_id']);

                // Convert family_ids string to array
                $ids = array_filter(explode(',', $emp->family_ids));

                $family = User::whereIn('id', $ids)->get()->map(function ($item) {
                    $item->is_family = 1;
                    return $item;
                });

            } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

                // Return error message in JSON if ID not found
                return response()->json(['success'=>false,'message' => 'Invalid Id found'], 200);
            }

            $response=[
                'success'=>true,
                'message'=>'Family Member fetched successfully.',
                'user'=>$family
            ];

            return response()->json($response);
        }
    }


}