<?php

namespace App\Http\Controllers\Manufacturing;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Auth;
use App\Models\Machinery;
use App\Models\MachineMaintenance;

class MachineryController extends Controller
{
    public function index(Request $request)
    {
        $query = Machinery::with('workstation:id,name','entry_by:id,name')
            ->where('rolledback',0);

        if ($request->has('search')) {
            $search = $request->input('search');
            $query->where(function($q) use ($search) {

                $q->where('machine_name', 'like', '%' . $search . '%')

                  ->orWhere('machine_id', $search)

                  ->orWhere('model_number', 'like', '%' . $search . '%')

                  ->orWhere('manufacturer', 'like', '%' . $search . '%')

                  ->orWhere('status', 'like', '%' . $search . '%');

                //   ->orWhereHas('workstation', function ($query) use ($request) {
                //     $query->where('name', 'LIKE', '%' . $request['search'] . '%');
                // });

            });
        }

        if ($request->has('status')) {
            $status = $request->input('status');
            $query->where('status', $status);
        }

        if ($request->has('is_active')) {
            $is_active = $request->input('is_active');
            $query->where('is_active', $is_active);
        }

        if ($request->has('availability_status')) {
            $availability_status = $request->input('availability_status');
            $query->where('availability_status', $availability_status);
        }

        if ($request->has('workstation_id')) {
            $workstation_id = $request->input('workstation_id');
            $query->where('machinery.workstation_id', $workstation_id);
        }

        $count=$query->count();

        // Sorting 
        if(isset($request['sort_by']) && $request['sort_by']!='' && $request['sort_by']!=null){
                
            $sort_order=$request['order_by']==1?'asc':'desc';

            $query = $query->orderby($request['sort_by'],$sort_order);

        }else{
            $query = $query->orderby('id','desc');
        }
        
        $machinery=$query->skip($request['noofrec']*($request['currentpage']-1))->take($request['noofrec']??50)
                // ->orderBy('id','desc')
                ->get();

        return $response=[
            'success'=>true,
            'total'=>$count,
            'machinery'=>$machinery,
            'message'=>'All Machinery Listed Successfully'
        ];
    
    }

    // Store a newly created machinery item
    public function store(Request $request)
    {

       $dump= Machinery::create([
            'machine_name' => $request->input('machine_name' ?? ''),
            'machine_id' => $request->input('machine_id'),
            'model_number' => $request->input('model_number' ?? ''),
            'manufacturer' => $request->input('manufacturer' ?? ''),
            'purchase_date' => $request->input('purchase_date' ?? ''),
            'running_time' => $request->input('running_time' ?? ''),
            'start_time' => $request->input('start_time' ?? ''),
            'end_time' => $request->input('end_time' ?? ''),
            'operation_id' => $request->input('operation_id' ?? ''),
            'status' => $request->input('status' ?? ''),
            'workstation_id' => $request->input('workstation_id' ?? ''),
            'notes' => $request->input('notes' ?? ''),
            'attachment' => $request->input('attachment' ?? ''),
        ]);


        return response()->json(['message' => 'Machinery created successfully'], 201);
    }
    
    // Store a newly created machinery item
    public function record_maintenance(Request $request)
    {

       $dump= MachineMaintenance::create([
            'machine_id' => $request->input('machine_id' ?? ''),
            'date_time' => $request->input('date_time' ?? ''),
            'done_by' => $request->input('done_by' ?? ''),
            'remarks' => $request->input('remarks' ?? ''), 
            'attachment' =>$request->input('attachment' ?? ''),
        ]);


        return response()->json(['message' => 'Maintenance recorded successfully'], 201);
    }

    // Display the specified machinery item
    public function show(Request $request)
    {
        $id= $request->id;
        $machine = Machinery::with('workstation','entry_by:id,name','machine_maintenance')
                        ->where('rolledback',0)
                        ->first();
                     
        // $machine_maintenance= MachineMaintenance::where('machine_id', $id)->get();

        if (!$machine) {
            return response()->json(['message' => 'Machinery item not found'], 404);
        }
        
        return $response = [
             'success' => true,
             'message' => 'Machine detail fetched Successfully',
             'machine' => $machine,
            //  'machine_maintenance' => $machine_maintenance
        ];

        return response()->json($machine);
    }

    // Update the specified machinery item
    public function update(Request $request)
    {
        // $validator = Validator::make($request->all(), [
        //     'machine_name' => 'required|max:100',
        //     'model_number' => 'required|max:50',
        //     'manufacturer' => 'required|max:100',
        //     'purchase_date' => 'required|date',
        //     'last_maintenance_date' => 'nullable|date',
        //     'next_maintenance_date' => 'nullable|date',
        //     'availability_status' => 'required|max:50',
        //     'available_in' => 'nullable|max:50',
        //     'status' => 'required|boolean',
        //     'workstation_id' => 'required|max:50'
        // ]);

        // if ($validator->fails()) {
        //     return response()->json(['errors' => $validator->errors()], 400);
        // }

        $id= $request->id;

        $affected = DB::table('machinery')
                      ->where('id', $id)
                      ->update([
            'machine_name' => $request->input('machine_name' ?? ''),
            'model_number' => $request->input('model_number' ?? ''),
            'manufacturer' => $request->input('manufacturer' ?? ''),
            'purchase_date' => $request->input('purchase_date' ?? ''),
            'start_time' => $request->input('start_time' ?? ''),
            'end_time' => $request->input('end_time' ?? ''),
            'operations' => $request->input('operations' ?? ''),
            'status' => $request->input('status' ?? ''),
            'workstation_id' => $request->input('workstation_id' ?? ''),
            'notes' => $request->input('notes' ?? ''),
            'attachment' => $request->input('attachment' ?? ''),
                      ]);

        if ($affected === 0) {
            return response()->json(['message' => 'Machinery item not found or no changes made'], 404);
        }

        return response()->json(['message' => 'Machinery item updated successfully']);
    }

    // Delete a workstation (soft delete by setting status to 0)
    public function destroy(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'id' => 'required',
        ]);
                                                                                                    
        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 400);
        }
        Machinery::where('id', $request['id'])->update(['rolledback' => 1]);

        return response()->json(['message' => 'Machinery deleted successfully','success'=>true]);
    }

     // Update status Active and In Active
     public function status(Request $request){

        // Validate Item

        $validator=validator($request->all(),[
           'machinery_id'=>'required|integer',
           'is_active'=>'required|integer'
       ]);

       if ($validator->fails()) { 

           return [
               'success' => false, 
               'message' => $validator->errors()->first(),
           ];

       } else {

           try{

               $machinery =  Machinery::where('id',$request->input('machinery_id'))->first();

               $machinery['is_active']=$request['is_active'];

               $machinery->update();

               $response=[
                   'success'=>true,
                   'message'=>'Machinery Status Updated successfully.'
               ];

           } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {

               // Return error message in JSON if ID not found
               return response()->json(['message' => 'Invalid Id found'], 404);
           }

           return response()->json($response);

       }

   }
}
