<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function parent_category(){
        return $this->belongsTo('App\Models\Category','parent_id')->where('is_disabled',0);
    }
    public function sub_category(){
        return $this->hasMany('App\Models\Category','parent_id','id')->where('is_disabled',0);
    }

}
