<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\OrderItem;
use App\Models\Document;
use Auth;

class Order extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function items(){
        return $this->hasMany(OrderItem::class);
    }

    public function documents(){
        return $this->hasMany(Document::class,'order_id');
    }

    public function vendor(){
        return $this->belongsTo('App\Models\User','vendor_id');
    }
    public function customer(){
        return $this->belongsTo('App\Models\User','enteredbyid');
    }

    public function order_tracking(){
        return $this->hasMany('App\Models\OrderTracking','order_id');
    }

     protected static function boot()
    {
        parent::boot();

        Order::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
            }
        });
    }
}
