<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Auth;

class Quotation extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function items(){
        return $this->hasMany('App\Models\QuotationItem', 'transaction_id');
    }

    public function customer(){
        return $this->belongsTo('App\Models\User', 'customer_id');
    }

    public function activity(){
        return $this->hasMany('App\Models\Activity','module_id')->where('module',"Quotation");
    }

    public function entry_by(){
        return $this->belongsTo('App\Models\User','enteredbyid');
    }
    

    protected static function boot()
    {
        parent::boot();

        Quotation::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
