<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Auth;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     * 
     */
    protected $guarded = [];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'remember_token',
    ];


    // public function organisation(){
    //     return $this->hasMany('App\Models\Organisation','user_id');
    // }

    // public function user_organisation(){
    //     return $this->hasMany('App\Models\UserOrganisation','user_id');
    // }

    public function address(){
        return $this->hasMany('App\Models\Address','user_id');
    }

    // public function contact_person(){
    //     return $this->hasMany('App\Models\ContactPerson','user_id');
    // }

    public function billing_address(){
        return $this->belongsTo('App\Models\Address','user_id')->where('is_billing',1);
    }

    public function shipping_address(){
        return $this->belongsTo('App\Models\Address','user_id');
    }

    public function documents(){
        return $this->hasMany('App\Models\Document','user_id');
    }

    // public function active_organisation(){
    //     return $this->belongsTo('App\Models\Organisation','active_organisation','organisation_id');
    // }
 
    
     public function bank_details(){
        return $this->hasMany('App\Models\BankDetails','user_id');
    }
    
    protected static function boot()
    {
        parent::boot();

        User::creating(function($model) {
            $user = Auth::user();
            if($user!=null){
                $model->enteredbyid = $user->id;
                // $model->organisation_id = $user->active_organisation;
            }
        });
    }
}
