<?php

namespace App\Service;
use App\Models\User;
use Auth;
use Carbon\Carbon;
use App\Models\Company;

class StaticMaster
{

	// Transaction types
	public static $OPENING_STOCK_TYPE=1;
	public static $SALE_TRANSACTION_TYPE=2;
	public static $PURCAHSE_TRANSACTION_TYPE=3;
    public static $CREDIT_NOTE=4;
	public static $DEBIT_NOTE=5;
	public static $MODIFY_STOCK=6;
	public static $JOURNAL=7;



	// Status of transactions
	public static $STATUS_DRAFT = 0; // draft status for transaction
	public static $STATUS_APPROVED = 1; // Approved
	public static $STATUS_REJECTED = 2; // sent to customer/client status for transaction and accepted
	

	public static function getCurrentFinancialYear($organisation_id){
		$today = Carbon::today();
		$company = Organisation::where('organisation_id',$organisation_id)->first();
		$startmonth = null;
		if($company!=null){
			$startmonth = $company['startmonthfy']; 
		} else {
			$startmonth = 4;
		}
		$currentmonth = $today->format('m');
		$fy = $today->format('Y');
		if($currentmonth<$startmonth){
			$fy = $fy -1;
		}
		return $fy;
	}
	
	public static function getStartDayOfFinancialYear($companyid,$fy){
		$company = Company::where('companyid',$companyid)->first();
		$startmonth = null;
		if($company!=null){
			$startmonth = $company['startmonthfy']; 
		} else {
			$startmonth = 4;
		}
		$startday = Carbon::createfromformat('Y-m-d',$fy.'-'.$startmonth.'-1');
		return $startday;
	}

	public static function getLastDayOfFinancialYear($companyid,$fy){
		$company = Company::where('companyid',$companyid)->first();
		$endmonth = null;
		if($company!=null){
			$endmonth = $company['endmonthfy'];
			if($endmonth!=12){
				$fy = $fy + 1;
			}
			//dec is also 31 
		} else {
			$endmonth = 3;
			//march is also 31
			$fy = $fy + 1;
		}
		$lastday = Carbon::createfromformat('Y-m-d',$fy.'-'.$endmonth.'-31');
		return $lastday;
	}
}