<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});


//Atuh Users
Route::post('login','AuthController@loginwithemailpassword'); //login qith email and password
Route::post('register','AuthController@register'); //register Organiation
Route::get('forgot/password','AuthController@forgotPassword'); //forgot password
Route::post('verify/otp','AuthController@verifyOtp'); //Verify OTP WITH EMAIL

Route::get('verify/mail','AuthController@verifyMail'); //Verify EMAIL

// Firebase Auth
Route::post('login/firebase','AuthController@loginwithfirebase');


// Route::post('form/createupdate','Api\UserController@createupdateuser');
Route::post('get/user/details','Api\UserController@getuserdetails');

Route::get('test/test','Api\TestController@test');

//Request Demo create
Route::post('request/demo/create','Api\RequestDemoController@createUpdateRequestDemo');


Route::group(['middleware' => ['auth:sanctum']], function () {
    // Request Demo
    Route::post('request/demo/list','Api\RequestDemoController@getRequestDemo');

    // Dashboard
    Route::post('dashboard/count','Api\DashboardController@dashboardCount');

    //users
    Route::post('change/password','AuthController@changePassword'); //change password
    Route::post('profile/createupdate','Api\ProfileController@updateProfileByAdmin');
    Route::post('user/getloggedinuser','Api\ProfileController@getuser');
    Route::post('users/list','Api\UserController@fetchuser');
    Route::post('user/updatefield','Api\UserController@userupdatefield');
    Route::post('user/create/update','Api\UserController@createUpdateUser');
    Route::post('user/view','Api\UserController@getuserdetails');

    // Customer
    Route::post('customer/create/update','Api\UserController@createUpdateUser');
    Route::post('customers/list','Api\UserController@fetchuser');
    Route::post('customer/view','Api\UserController@getuserdetails');
    Route::post('customer/status','Api\UserController@status');
    Route::post('customer/delete','Api\UserController@delete');

    // Vendors
    Route::post('vendors/create/update','Api\UserController@createUpdateUser');
    Route::post('vendors/list','Api\UserController@fetchuser');
    Route::post('vendors/view','Api\UserController@getuserdetails');
    Route::post('vendors/status','Api\UserController@status');
    Route::post('vendors/delete','Api\UserController@delete');

    // master
    Route::post('master/fetch/required','Api\MasterController@fetchrequired');
    Route::get('master/listall','MasterController@listall');
    Route::post('master/values','MasterController@getValues');
    Route::post('master/createupdate','MasterController@createupdate');
    Route::get('master/descriptions','MasterController@masterdescription');
    Route::get('master/delete','MasterController@delete');

    // Addressess & Currency
    Route::post('get/country', 'Api\AddressController@getcountry');
    Route::post('get/state', 'Api\AddressController@getstate');
    Route::post('get/city', 'Api\AddressController@getcity');
    Route::post('get/currency', 'Api\AddressController@getAllCurrency');
    Route::post('adreess/create/update', 'Api\AddressController@adreessCreateUpdate'); //user_id needed
    Route::post('adreess/list', 'Api\AddressController@addressList'); //user_id needed

    // Documents
    Route::post('document/create/update', 'Api\DocumentController@documentCreateUpadate');
    Route::post('document/list', 'Api\DocumentController@documentList');
    Route::post('document/delete', 'Api\DocumentController@deleteDocument');
    Route::post('document/details', 'Api\DocumentController@documentDetails');

    // Sequence Format 
    Route::post('sequence/create/update', 'Api\SequenceFormatController@createUpdateSequence');
    Route::post('sequence/list', 'Api\SequenceFormatController@fetchSequence');
    Route::post('sequence/delete', 'Api\SequenceFormatController@delete');

    // Reports Counts
    Route::post('get/reports/counts', 'Api\ReportController@getCountsReport');

    // Items
    Route::post('item/create/update','Api\ItemController@itemCreateUpdate');
    Route::post('item/list','Api\ItemController@itemList');
    Route::post('item/details','Api\ItemController@itemDetails');
    Route::post('items/import','Api\ItemController@import');
    Route::get('items/export','Api\ItemController@export');
    Route::post('item/status','Api\ItemController@status');
    Route::post('item/delete','Api\ItemController@delete');

    // Category
    Route::post('category/create/update','Api\CategoryController@categoryCreateUpdate');
    Route::post('category/list','Api\CategoryController@categoryList');
    Route::post('sub-category/list','Api\CategoryController@subCategoryList');
    Route::post('category/delete','Api\CategoryController@delete');
    Route::post('category/status','Api\CategoryController@status');

    // Order
    Route::post('order/create/update','Api\OrderController@orderCreateUpdate');
    Route::post('order/list','Api\OrderController@orderList');
    Route::post('order/list/vendor','Api\OrderController@orderListVendor');
    Route::post('order/details','Api\OrderController@orderDetails');
    Route::post('order/status','Api\OrderController@orderStatus');
    Route::post('order/delete','Api\OrderController@orderDelete');
    Route::post('order/list/filters','Api\OrderController@orderFilters');
    Route::post('order/vendor/ratings','Api\OrderController@orderRatings');
    Route::post('order/vendor/update','Api\OrderController@updateVendor');
    Route::post('order/update/ratings','Api\OrderController@updateRatings');

    // Quotation
    Route::post('quotation/create/update','Api\QuotationController@quotationCreateUpdate');
    Route::post('quotation/list','Api\QuotationController@quotationList');
    Route::post('quotation/details','Api\QuotationController@quotationDetails');
    Route::post('quotation/status','Api\QuotationController@statusQuotation');
    Route::post('quotation/delete','Api\QuotationController@quotationDelete');
    Route::post('quotation/vendor/details','Api\QuotationController@quotationVendorDetails');

    // Category Order Status
    Route::post('status/create/update','Api\StatusController@statusCreateUpdate');
    Route::post('status/list','Api\StatusController@statusList');
    Route::post('sub-status/list','Api\StatusController@subStatusList');
    Route::post('status/delete','Api\StatusController@delete');
    Route::post('status/status','Api\StatusController@status');

}); 









